(function($){	
  jQuery.fn.toggler = function(options) {
  
    var defaults = {
      toggler:         '.toggler', 
      toggler_content: '.toggler-content'
    };
    
    var options = jQuery.extend(defaults, options);
    
    return this.each(function() {
    
  	  var tabgroup        = jQuery(this);
      var toggler         = tabgroup.children().find(options.toggler);
      var toggler_content = tabgroup.children().find(options.toggler_content);
      
      toggler.each(function() {
        var cur_toggler = jQuery(this);
        var cur_toggler_content = cur_toggler.next(toggler_content);
        
        if(cur_toggler_content.is(".active")) {
          cur_toggler_content.show();
        }
        else {
          cur_toggler_content.hide();
        }
        
        cur_toggler.bind('click', function() {
          if(cur_toggler.is('.active')) {
            cur_toggler.removeClass('active');
            cur_toggler_content.removeClass('active').slideUp();
          }
          else {
            if(tabgroup.is('.close-all')) {
              toggler.removeClass('active');
              toggler_content.removeClass('active').slideUp();
            }
            cur_toggler.addClass("active");
            cur_toggler_content.addClass("active").slideDown();
          }
        });
        
      });
      
    });
    
  };
  
  
})(jQuery);


(function ($) {
  $.fn.tabset = function () {
      var $tabsets = $(this);
      $tabsets.each(function (i) {
          var $tabs = $('li.tab a', this);
          $tabs.click(function (e) {
              var $this = $(this);
                  panels = $.map($tabs, function (val, i) {
                      return $(val).attr('href');
                  });
              $(panels.join(',')).hide();
              $tabs.removeClass('selected');
              $this.addClass('selected').blur();
              $($this.attr('href')).show();
              e.preventDefault();
              return false;
          }).first().triggerHandler('click');
      });
  };
})(jQuery);



//Flickr plugin
(function($) {
  $.fn.jflickrfeed = function(settings, callback) {
    settings = $.extend(true, {
      flickrbase: 'http://api.flickr.com/services/feeds/',
      feedapi: 'photos_public.gne',
      limit: 20,
      qstrings: {
        lang: 'en-us',
        format: 'json',
        jsoncallback: '?'
      },
      cleanDescription: true,
      useTemplate: true,
      itemTemplate: '',
      itemCallback: function() {}
    }, settings);
    var url = settings.flickrbase + settings.feedapi + '?';
    var first = true;
    for (var key in settings.qstrings) {
      if (!first)
        url += '&';
      url += key + '=' + settings.qstrings[key];
      first = false;
    }
    return $(this).each(function() {
      var $container = $(this);
      var container = this;
      $.getJSON(url, function(data) {
        $.each(data.items, function(i, item) {
          if (i < settings.limit) {
            if (settings.cleanDescription) {
              var regex = /<p>(.*?)<\/p>/g;
              var input = item.description;
              if (regex.test(input)) {
                item.description = input.match(regex)[2]
                if (item.description != undefined)
                  item.description = item.description.replace('<p>', '').replace('</p>', '');
              }
            }
            item['image_s'] = item.media.m.replace('_m', '_s');
            item['image_t'] = item.media.m.replace('_m', '_t');
            item['image_m'] = item.media.m.replace('_m', '_m');
            item['image'] = item.media.m.replace('_m', '');
            item['image_b'] = item.media.m.replace('_m', '_b');
            delete item.media;
            if (settings.useTemplate) {
              var template = settings.itemTemplate;
              for (var key in item) {
                //console.log(key);
                var rgx = new RegExp('["\'][^\'"]+{{' + key + '}}["\']|["\']{{' + key + '}}["\']', 'g');
                template = template.replace(rgx, '"'+item[key]+'"');
              }
              $container.append(template)
            }
            settings.itemCallback.call(container, item);
          }
        });
        if ($.isFunction(callback)) {
          callback.call(container, data);
        }
      });
    });
  }
})(jQuery);

//Fit Video
(function( $ ){

  $.fn.fitVids = function( options ) {
    var settings = {
      customSelector: null
    }

    var div = document.createElement('div'),
        ref = document.getElementsByTagName('base')[0] || document.getElementsByTagName('script')[0];

    div.className = 'fit-vids-style';
    div.innerHTML = '&shy;<style>         \
      .fluid-width-video-wrapper {        \
         width: 100%;                     \
         position: relative;              \
         padding: 0;                      \
      }                                   \
                                          \
      .fluid-width-video-wrapper iframe,  \
      .fluid-width-video-wrapper object,  \
      .fluid-width-video-wrapper embed {  \
         position: absolute;              \
         top: 0;                          \
         left: 0;                         \
         width: 100%;                     \
         height: 100%;                    \
      }                                   \
    </style>';

    ref.parentNode.insertBefore(div,ref);

    if ( options ) {
      $.extend( settings, options );
    }

    return this.each(function(){
      var selectors = [
        "iframe[src*='player.vimeo.com']",
        "iframe[src*='www.youtube.com']",
        "iframe[src*='www.kickstarter.com']",
        "iframe[src*='www.dailymotion.com']",
        "object",
        "embed"
      ];

      if (settings.customSelector) {
        selectors.push(settings.customSelector);
      }

      var $allVideos = $(this).find(selectors.join(','));

      $allVideos.each(function(){
        var $this = $(this);
        if (this.tagName.toLowerCase() == 'embed' && $this.parent('object').length || $this.parent('.fluid-width-video-wrapper').length) { return; }
        var height = ( this.tagName.toLowerCase() == 'object' || $this.attr('height') ) ? $this.attr('height') : $this.height(),
            width = $this.attr('width') ? $this.attr('width') : $this.width(),
            aspectRatio = height / width;
        if(!$this.attr('id')){
          var videoID = 'fitvid' + Math.floor(Math.random()*999999);
          $this.attr('id', videoID);
        }
        $this.wrap('<div class="fluid-width-video-wrapper"></div>').parent('.fluid-width-video-wrapper').css('padding-top', (aspectRatio * 100)+"%");
        $this.removeAttr('height').removeAttr('width');
      });
    });
  }
})( jQuery );


//Jquery Auto Height Script 1.5
!function(a){a.fn.equalHeights=function(){var b=0,c=a(this);return c.each(function(){var c=a(this).innerHeight();c>b&&(b=c)}),c.css("height",b)},a("[data-equal]").each(function(){var b=a(this),c=b.data("equal");b.find(c).equalHeights()})}(jQuery);



jQuery(document).ready(function() {
	
      //skill bar 
      jQuery('.skillbar').each(function(){
          dataperc = jQuery(this).attr('data-perc'),
          jQuery(this).find('.skill-percentage').animate({ "width" : dataperc + "%"}, dataperc*20);
      });

		
		// tabs
		jQuery('div.tabset').tabset();

    // Equal height 
    jQuery('.equal-height .module-content .customequal-height > div').equalHeights();


		// Toggler			  
		jQuery(".togglergroup").toggler();

    //Responsive Video
    jQuery(".video-embed").fitVids();

		
}); // end ready function

jQuery(function($){ jQuery('.video-embed').fitVids(); });