<?php
	/**
	* @package		BDT Twitter Module
	* @copyright	BDThemes Ltd. All rights reserved.
	* @license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
	*/

	// no direct access
	defined('_JEXEC') or die;

	$uniqe_id = 'bdt_twitter'.rand(9, 9999);
?>

<div id="<?php echo $uniqe_id;?>" class="bdt-tweet-container">
	<?php if($params->get('upper_text')) : ?>
		<div class="bdt_twitter_upper_text"><?php echo $params->get('upper_text');?></div> 
	<?php endif ?>


	<?php if($params->get('header', 1)) : ?>
	<div id="bdt-header">
		<?php if($params->get('twitter_icon', 1)) : ?>
			<div id="bdt-twitter-icon"><a href="http://twitter.com" target="_blank"><img  src="modules/mod_bdttwitter_module/images/twitter-icon.png"/></a></div>
		<?php endif; ?>
		<?php if($params->get('type', 1)) : ?>
			<a href="https://twitter.com/<?php echo $data->tweets[0]->screenName; ?>" target="_blank">
				<img src="<?php echo $data->tweets[0]->profileImage; ?>" class="bdt-avatar" />
				<span class="bdt-display-name"><?php echo $data->tweets[0]->displayName; ?></span><br>
				<span class='bdt-screen-name'> @<?php echo $data->tweets[0]->screenName; ?></span>
			</a>
			<div style="clear: both;"></div>
			<?php else: ?>
				<?php if($params->get('link_title', 1)) : ?>
					<a href="https://twitter.com/search/<?php echo $params->get('query', ''); ?>" target="_blank"><?php echo $params->get('title', '') ?></a>
				<?php else: ?>
					<?php echo $params->get('title', ''); ?>
				<?php endif; ?>
			<?php endif; ?>	    
	</div>
	<?php endif; ?>

	<div class="bdt_twitter_carousel">


		<?php foreach($data->tweets as $key => $tweet): ?>
			<div>
				<?php if($params->get('avatars', 1)): ?>
					<div>
						<a href="https://twitter.com/intent/user?screen_name=<?php echo $tweet->screenName; ?>" target="_blank">
							<img src="<?php echo $tweet->profileImage; ?>" class="bdt-avatar" style="width: 35px;" />
						</a>
					</div>
				<?php endif; ?>

				<div class="bdt-tweet" <?php echo ($params->get('avatars')) ? 'style="padding-left: 40px;"' : ''; ?>>
					<?php if($params->get('display_name', 1)): ?>
						<a href="https://twitter.com/intent/user?screen_name=<?php echo $tweet->screenName; ?>" target="_blank"><?php echo $tweet->screenName; ?></a> 
					<?php endif; ?>
					<?php echo $tweet->text; ?>
				</div>

				<div class="bdt-tweet-data" <?php echo ($params->get('avatars', 1)) ? 'style="margin-left: 40px;"' : ''; ?>>
						<?php if($params->get('timestamps', 1)): ?>
							<a href="https://twitter.com/<?php echo $tweet->screenName; ?>/statuses/<?php echo $tweet->id; ?>" target="_blank"><?php echo $tweet->time; ?></a>
							<?php if($params->get('reply', 1) || $params->get('retweet', 1) || $params->get('favorite', 1)): ?>
								&bull;
							<?php endif; ?>
						<?php endif; ?>
						<?php if($params->get('reply', 1)): ?>
							<a href="https://twitter.com/intent/tweet?in_reply_to=<?php echo $tweet->id; ?>" target="_blank">reply</a>
							<?php if($params->get('retweet', 1) || $params->get('favorite', 1)): ?>
								&bull;
							<?php endif; ?>
						<?php endif; ?>
						<?php if($params->get('retweet', 1)): ?>
							<a href="https://twitter.com/intent/retweet?tweet_id=<?php echo $tweet->id; ?>" target="_blank">retweet</a>
							<?php if($params->get('favorite', 1)): ?>
								&bull;
							<?php endif; ?>
						<?php endif; ?>
						<?php if($params->get('favorite', 1)): ?>
							<a href="https://twitter.com/intent/favorite?tweet_id=<?php echo $tweet->id; ?>" target="_blank">favorite</a>
						<?php endif; ?>
					</div>



	        </div>
		<?php endforeach; ?>
	</div>
	
		<?php if($params->get('twitter_follow', 1)) : ?>
	     <div class="twitter-follow">
	    	<a href="https://twitter.com/<?php echo $params->get('twitter_username', ''); ?>" class="twitter-follow-button" data-show-count="false">Follow @<?php echo $params->get('twitter_username', ''); ?></a>
			<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script>
	    </div>
	    <?php endif; ?>

	<?php if($params->get('lower_text')) : ?>
		<div><p class="color"><?php echo $params->get('lower_text');?></p></div>
	<?php endif; ?>

</div>




<script type="text/javascript">

	jQuery(document).ready(function($) {
		jQuery('#<?php echo $uniqe_id;?> .bdt_twitter_carousel').owlCarousel({

			// // Most important owl features
			items: [<?php echo $params->get('twitter_display'); ?>],
		    itemsDesktop : [<?php echo $params->get('itemsDesktop'); ?>],
		    itemsDesktopSmall : [<?php echo $params->get('itemsDesktopSmall'); ?>],
		    itemsTablet: [<?php echo $params->get('itemsTablet'); ?>],
		    itemsMobile : [<?php echo $params->get('itemsMobile'); ?>],

		    //Basic Speeds
			slideSpeed : <?php echo $params->get('slide_speed'); ?>,
			paginationSpeed : <?php echo $params->get('paginationSpeed'); ?>,

			// Auto Play
			autoPlay : <?php echo $params->get('autoPlay'); ?>,
   			stopOnHover : <?php echo $params->get('stopOnHover'); ?>,

    		// Navigation
			navigation: <?php echo $params->get('navigation'); ?>,
		    navigationText : [<?php echo $params->get('navigation_text'); ?>],
		 
		    //Pagination
		    pagination : <?php echo $params->get('pagination'); ?>,
		    paginationNumbers: <?php echo $params->get('pagination_number'); ?>,

		    //Auto height
			autoHeight: <?php echo $params->get('autoHeight'); ?>

			// Animation Style 
			//singleItem : true,
			//transitionStyle: "backSlide"
 
				 

		});
		<?php if ($params->get('grayscale')=="true") : ?>
		jQuery('#<?php echo $uniqe_id;?> div img').hoverizr();
		<?php endif; ?>
	});
</script>