(function($) {
  "use strict";
	jQuery(document).ready(function() {
		// CSS3 Transitions
		jQuery('*').each(function(){
			if(jQuery(this).attr('data-animation')) {
				var animationName = jQuery(this).attr('data-animation'),
					animationDelay = "delay-"+jQuery(this).attr('data-animation-delay');
				jQuery(this).appear(function() {
					jQuery(this).addClass('animated').addClass(animationName);
					jQuery(this).addClass('animated').addClass(animationDelay);
				});
			} 
		});
		
		// Flip-box	
		var is_touch_device = 'ontouchstart' in document.documentElement;		
		jQuery('.flip-box-wrap').click(function(){			
			jQuery('.ifb-hover').removeClass('ifb-hover');
		})
		if(!is_touch_device){
			jQuery('.ifb-flip-box').hover(function(event){			
				event.stopImmediatePropagation();
				jQuery(this).addClass('ifb-hover');			
			},function(event){
				event.stopImmediatePropagation();
				jQuery(this).removeClass('ifb-hover');			
			})
		}
		jQuery('.ifb-flip-box').click(function(event){
			event.stopPropagation();
			if(jQuery(this).hasClass('ifb-hover')){				
				jQuery(this).removeClass('ifb-hover');							
			}
			else{ 				
				jQuery('.ifb-hover').removeClass('ifb-hover');
				jQuery(this).addClass('ifb-hover');
			}
		});
	});
})(jQuery);