<?php

/**
 * @package Unite Showbiz for Joomla 1.7-3.1
 * @author UniteCMS.net
 * @copyright (C) 2012 Unite CMS, All Rights Reserved. 
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;

/**
 * Form Field class for the Joomla Platform.
 * Provides a modal media selector including upload mechanism
 *
 * @package     Joomla.Platform
 * @subpackage  Form
 * @since       11.1
 */
class JFormFieldMymediasingle extends JMasterFieldUniteShowbiz {

    /**
     * The form field type.
     *
     * @var    string
     * @since  11.1
     */
    protected $type = 'MyMediaSingle';

    /**
     * The initialised state of the document object.
     *
     * @var    boolean
     * @since  11.1
     */
    protected static $initialised = false;

    /**
     * 
     * return nothing as label
     */
    public function getLabel() {
        return("");
    }

    /**
     * Method to get the field input markup for a media selector.
     * Use attributes to identify specific created_by and asset_id fields
     *
     * @return  string  The field input markup.
     *
     * @since   11.1
     */
    protected function getInput() {
        $assetField = $this->element['asset_field'] ? (string) $this->element['asset_field'] : 'asset_id';
        $authorField = $this->element['created_by_field'] ? (string) $this->element['created_by_field'] : 'created_by';
        $asset = $this->form->getValue($assetField) ? $this->form->getValue($assetField) : (string) $this->element['asset_id'];
        if ($asset == '') {
            $asset = JRequest::getCmd('option');
        }

        $link = (string) $this->element['link'];
        if (!self::$initialised) {

            // Load the modal behavior script.
            JHtml::_('behavior.modal');

            // Build the script.
            $script = array();
            $script[] = '	function jInsertFieldValue(value, id) {';
            $script[] = '		var old_id = document.id(id).value;';
            $script[] = '		if (old_id != id) {';
            $script[] = '			var elem = document.id(id);';
            $script[] = '			elem.value = value;';
            $script[] = '			elem.fireEvent("change");';
            $script[] = '		}';
            $script[] = '	}';

            // Add the script to the document head.
            JFactory::getDocument()->addScriptDeclaration(implode("\n", $script));

            self::$initialised = true;
        }

        // Initialize variables.
        $html = array();
        $attr = '';

        // Initialize some field attributes.
        $attr .= $this->element['class'] ? ' class="' . (string) $this->element['class'] . '"' : '';
        $attr .= $this->element['size'] ? ' size="' . (int) $this->element['size'] . '"' : '';

        // Initialize JavaScript field attributes.
        $attr .= $this->element['onchange'] ? ' onchange="' . (string) $this->element['onchange'] . '"' : '';

        $html[] = '	<input type="hidden" name="slide_image" id="' . $this->id . '"' . ' value="'
                . htmlspecialchars($this->value, ENT_COMPAT, 'UTF-8') . '"' . ' readonly="readonly"' . $attr . ' />';

        $directory = (string) $this->element['directory'];
        if ($this->value && file_exists(JPATH_ROOT . '/' . $this->value)) {
            $folder = explode('/', $this->value);
            array_shift($folder);
            array_pop($folder);
            $folder = implode('/', $folder);
        } elseif (file_exists(JPATH_ROOT . '/' . JComponentHelper::getParams('com_media')->get('image_path', 'images') . '/' . $directory)) {
            $folder = $directory;
        } else {
            $folder = '';
        }

        $buttonTitle = "Choose Image";

        $class = "modal";
        $buttonClass = $this->element["buttonclass"];
        if (!empty($buttonClass))
            $class .= " " . $buttonClass;

        // The button.
        $html[] = '<div>';
        $html[] = '		<a class="' . $class . ' choose_image" title="' . $buttonTitle . '"' . ' href="'
                . ($this->element['readonly'] ? '' : ($link ? $link : 'index.php?option=com_media&amp;view=images&amp;tmpl=component&amp;asset=' . $asset . '&amp;author='
                                . $this->form->getValue($authorField)) . '&amp;fieldid=' . $this->id . '&amp;folder=' . $folder) . '"'
                . ' rel="{handler: \'iframe\', size: {x: 800, y: 500}}">';
        $html[] = $buttonTitle . '</a>';


        $html[] = '	<div class="blank">';

        $html[] = '		<a class="' . $buttonClass . ' remove_image" title="' . JText::_('Remove Image') . '"' . ' href="#" onclick="';
        $html[] = 'document.id(\'' . $this->id . '\').value=\'\';';
        $html[] = 'document.id(\'' . $this->id . '\').fireEvent(\'change\');';
        $html[] = 'return false;';
        $html[] = '">';
        $html[] = JText::_('Remove Image') . '</a>';

        $html[] = '	</div>';
        $html[] = '</div>';

        return implode("\n", $html);
    }

}
