/*
* @category    Formulario Modelo Evolucion Historia Clinica Fisioterapia Evolucion 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCFisioterapia001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Fisioterapia Valoracion Inicial ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                //padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '100%',//width: 945,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'IDENTIFICACION',
                                autoHeight: true,
                                autoScroll: true,
                                anchor: '100%',//width: 935,
                                frame: true,
                                border: false,
                                id: 'fichaIdentifica',
                                layout: 'form',
                                items:[
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Fecha Nacimiento',
                                        id: 'sysPacienteHC1'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysPacienteHC2'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysPacienteHC3'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Direccion - Telefonos',
                                        id: 'sysPacienteHC4'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Estado Civil',
                                        id: 'sysPacienteHC5'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Procedencia',
                                        id: 'sysPacienteHC6'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 96,
                                                allowBlank: true,
                                                fieldLabel: 'Ocupacion',
                                                id: 'sysOcupacionHC'
                                            },
                                            {
                                                xtype: 'textarea',
                                                readOnly: true,
                                                width: 685,
                                                height: 22,
                                                id: 'sysOcupacionHCNom'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Ocupacion',
                                                id: 'btnSearchOcupacionHC',
                                                listeners:{
                                                    click : function(){
                                                        buscarciuo('sysOcupacionHC','sysOcupacionHCNom');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Etnia',
                                                name: 'Etnia',
                                                width: 370,
                                                allowBlank: true,
                                                store: 'StoreEtnia4505',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'sysEtniaHC'
                                            },
                                            {
                                                html: 'Escolaridad:'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Escolaridad',
                                                width: 370,
                                                allowBlank: true,
                                                store: 'StoreEscolaridad4505',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'sysEscolaridadHC'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'EVOLUCION',
                                autoHeight: true,
                                autoScroll: true,
                                anchor: '100%',//width: 945,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        height: 555,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                fieldLabel: 'Acompañante',
                                                name: 'Acompañante',
                                                id: 'strPacienteHC9'
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                title: 'TRABAJO',
                                                frame: true,
                                                anchor: '100%',
                                                padding: 10,
                                                border: false,
                                                autoHeight: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Ocupaciíon Actual',
                                                        name: 'Ocupaciíon Actual',
                                                        id: 'strPacienteHC10'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                title: 'ANTECEDENTES MEDICO QUIRURGICO',
                                                frame: true,
                                                anchor: '100%',
                                                padding: 10,
                                                border: false,
                                                autoHeight: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Patologicos',
                                                                name: 'Patologicos',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                value: 'NO',
                                                                triggerAction: 'all',
                                                                id: 'strPacienteHC11a',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strPacienteHC11').allowBlank = true;
                                                                            Ext.getCmp('strPacienteHC11').setValue(null);
                                                                            Ext.getCmp('strPacienteHC11').disable();
                                                                            Ext.getCmp('strPacienteHC11').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strPacienteHC11').enable();
                                                                            Ext.getCmp('strPacienteHC11').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Descripcion Ant. Patologicos',
                                                                id: 'strPacienteHC11'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Traumaticos',
                                                                name: 'Traumaticos',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                value: 'NO',
                                                                triggerAction: 'all',
                                                                id: 'strPacienteHC12a',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strPacienteHC12').allowBlank = true;
                                                                            Ext.getCmp('strPacienteHC12').setValue(null);
                                                                            Ext.getCmp('strPacienteHC12').disable();
                                                                            Ext.getCmp('strPacienteHC12').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strPacienteHC12').enable();
                                                                            Ext.getCmp('strPacienteHC12').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Descripcion Ant. Traumaticos',
                                                                id: 'strPacienteHC12'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Quirurgicos',
                                                                name: 'Quirurgicos',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                value: 'NO',
                                                                triggerAction: 'all',
                                                                id: 'strPacienteHC13a',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strPacienteHC13').allowBlank = true;
                                                                            Ext.getCmp('strPacienteHC13').setValue(null);
                                                                            Ext.getCmp('strPacienteHC13').disable();
                                                                            Ext.getCmp('strPacienteHC13').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strPacienteHC13').enable();
                                                                            Ext.getCmp('strPacienteHC13').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Descripcion Ant. Quirurgicos',
                                                                id: 'strPacienteHC13'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Alergicos',
                                                                name: 'Alergicos',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                value: 'NO',
                                                                triggerAction: 'all',
                                                                id: 'strPacienteHC14a',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strPacienteHC14').allowBlank = true;
                                                                            Ext.getCmp('strPacienteHC14').setValue(null);
                                                                            Ext.getCmp('strPacienteHC14').disable();
                                                                            Ext.getCmp('strPacienteHC14').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strPacienteHC14').enable();
                                                                            Ext.getCmp('strPacienteHC14').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Descripcion Ant. Alergicos',
                                                                id: 'strPacienteHC14'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Hospitalarios',
                                                                name: 'Hospitalarios',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                value: 'NO',
                                                                triggerAction: 'all',
                                                                id: 'strPacienteHC15a',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strPacienteHC15').allowBlank = true;
                                                                            Ext.getCmp('strPacienteHC15').setValue(null);
                                                                            Ext.getCmp('strPacienteHC15').disable();
                                                                            Ext.getCmp('strPacienteHC15').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strPacienteHC15').enable();
                                                                            Ext.getCmp('strPacienteHC15').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Descripcion Ant. Hospitalarios',
                                                                id: 'strPacienteHC15'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                title: 'HABITOS',
                                                frame: true,
                                                anchor: '100%',
                                                padding: 10,
                                                border: false,
                                                autoHeight: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Alcohol',
                                                                name: 'Alcohol',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                value: 'NO',
                                                                triggerAction: 'all',
                                                                id: 'strPacienteHC16'
                                                            },
                                                            {
                                                                html: 'Tabaco:'
                                                            },
                                                            {   
                                                                xtype: 'combo',
                                                                name: 'Tabaco',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                value: 'NO',
                                                                triggerAction: 'all',
                                                                id: 'strPacienteHC17'
                                                            },
                                                            {
                                                                html: 'Sustancias Psicoactivas:'
                                                            },
                                                            {   
                                                                xtype: 'combo',
                                                                name: 'Sustancias Psicoactivas',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                value: 'NO',
                                                                triggerAction: 'all',
                                                                id: 'strPacienteHC18'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Otros',
                                                        name: 'Otros Habitos',
                                                        id: 'strPacienteHC19'
                                                    }
                                                ]
                                            },
                                            /*{
                                                xtype: 'panel',
                                                layout: 'form',
                                                title: 'MEDICACIONES',
                                                frame: true,
                                                anchor: '100%',
                                                padding: 10,
                                                border: false,
                                                autoHeight: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Medicamentos Actuales',
                                                        name: 'Medicamentos Actuales',
                                                        id: 'strPacienteHC20'
                                                    }
                                                ]
                                            },*/
                                            {
                                                xtype: 'panel',
                                                layout: 'table',
                                                title: 'PROFESIONAL REMITENTE',
                                                frame: true,
                                                anchor: '100%',
                                                padding: 10,
                                                border: false,
                                                autoHeight: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 800,
                                                        allowBlank: true,
                                                        fieldLabel: 'Profesional Remitente',
                                                        name: 'Profesional Remitente',
                                                        id: 'strPacienteHC21'
                                                    }
                                                ]
                                            },
                                            /*{
                                                xtype: 'panel',
                                                layout: 'table',
                                                title: 'ENFERMEDAD ACTUAL',
                                                frame: true,
                                                anchor: '100%',
                                                padding: 10,
                                                border: false,
                                                autoHeight: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 800,
                                                        allowBlank: true,
                                                        fieldLabel: 'Enfermedad Actual',
                                                        name: 'Enfermedad Actual',
                                                        id: 'strPacienteHC22'
                                                    }
                                                ]
                                            },*/
                                            {
                                                xtype: 'panel',
                                                layout: 'table',
                                                title: 'CRONOLOGIA DE LA PATOLOGIA',
                                                frame: true,
                                                anchor: '100%',
                                                padding: 10,
                                                border: false,
                                                autoHeight: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 800,
                                                        allowBlank: true,
                                                        fieldLabel: 'Cronologia Patologia',
                                                        name: 'Cronologia Patologia',
                                                        id: 'strPacienteHC223'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                title: 'REPORTE DE PARACLINICOS',
                                                frame: true,
                                                anchor: '100%',
                                                padding: 10,
                                                border: false,
                                                autoHeight: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Electromiografia',
                                                        name: 'Electromiografia',
                                                        id: 'strPacienteHC224'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Radiografia',
                                                        name: 'Radiografia',
                                                        id: 'strPacienteHC225'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'TAC',
                                                        name: 'TAC',
                                                        id: 'strPacienteHC226'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'RMN',
                                                        name: 'RMN',
                                                        id: 'strPacienteHC228'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'OTROS',
                                                        name: 'OTROS',
                                                        id: 'strPacienteHC229'
                                                    }
                                                ]
                                            },
                                            /*{
                                                xtype: 'panel',
                                                layout: 'form',
                                                title: 'SISTEMA CARDIOVASCULAR Y PULMONAR - TEST Y MEDIDAS',
                                                frame: true,
                                                anchor: '100%',
                                                padding: 10,
                                                border: false,
                                                autoHeight: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'FC',
                                                        name: 'FC',
                                                        id: 'strPacienteHC30'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'FR',
                                                        name: 'FR',
                                                        id: 'strPacienteHC31'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'TA',
                                                        name: 'TA',
                                                        id: 'strPacienteHC32'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Relacion I/E',
                                                        name: 'Relacion I/E',
                                                        id: 'strPacienteHC34'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Perfusion Distal',
                                                        name: 'Perfusion Distal',
                                                        id: 'strPacienteHC35'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Tipo Torax',
                                                        name: 'Tipo Torax',
                                                        id: 'strPacienteHC36'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Patron Respiratorio',
                                                        name: 'Patron Respiratorio',
                                                        id: 'strPacienteHC37'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Expansibilidad Toracica',
                                                        name: 'Expansibilidad Toracica',
                                                        id: 'strPacienteHC38'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Auscultacion Pulmonar',
                                                        name: 'Auscultacion Pulmonar',
                                                        id: 'strPacienteHC39'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'Talla (cm)',
                                                                name:"Talla (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEF_Talla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Talla').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Peso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100; 
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys_EF1',
                                                                value: 'Peso (Kg):'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                emptyText: '(Kg)',
                                                                name:"Peso (Kg)",
                                                                id: 'intEF_Peso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Peso').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Talla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100; 
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys_EF2',
                                                                value: 'IMC:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                value: 0,
                                                                name: "IMC",
                                                                id: 'intEF_IMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: "IMC - Clasificación",
                                                                id: 'strEF_IMCClasificacon'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },*/
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                title: 'SISTEMA MUSCULOESQUELETICO',
                                                frame: true,
                                                anchor: '100%',
                                                padding: 10,
                                                border: false,
                                                autoHeight: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'DOLOR',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Localizacion',
                                                                name: 'Localizacion',
                                                                id: 'strPacienteHC41'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Intensidad',
                                                                name: 'Intensidad',
                                                                id: 'strPacienteHC43'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Duracion',
                                                                name: 'Duracion',
                                                                id: 'strPacienteHC44'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Factores Precipitantes',
                                                                name: 'Factores Precipitantes',
                                                                id: 'strPacienteHC47'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Factores Calmantes',
                                                                name: 'Factores Calmantes',
                                                                id: 'strPacienteHC48'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Periodicidad',
                                                                name: 'Periodicidad',
                                                                id: 'strPacienteHC49'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Espasmos Musculares',
                                                        name: 'Espasmos Musculares',
                                                        id: 'strPacienteHC51'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Puntos Dolorosos',
                                                        name: 'Puntos Dolorosos',
                                                        id: 'strPacienteHC52'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'EDEMA',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Localizacion',
                                                                name: 'Localizacion',
                                                                id: 'strPacienteHC53'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Intensidad',
                                                                name: 'Intensidad',
                                                                id: 'strPacienteHC54'
                                                            }/*,
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Color',
                                                                name: 'Color',
                                                                id: 'strPacienteHC55'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Consistencia',
                                                                name: 'Consistencia',
                                                                id: 'strPacienteHC55a'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Temperatura',
                                                                name: 'Temperatura',
                                                                id: 'strPacienteHC56'
                                                            }*/
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'TROFISMO MUSCULAR',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Miembros Superiores',
                                                                layout: 'table',
                                                                anchor: '99%',
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        width: 800,
                                                                        allowBlank: true,
                                                                        fieldLabel: 'Miembros Superiores',
                                                                        name: 'Miembros Superiores',
                                                                        id: 'memPacienteHC57'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Miembros Inferiores',
                                                                layout: 'table',
                                                                anchor: '99%',
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        width: 800,
                                                                        allowBlank: true,
                                                                        fieldLabel: 'Miembros Inferiores',
                                                                        name: 'Miembros Inferiores',
                                                                        id: 'memPacienteHC58'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'FLEXIBILIDAD',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'AMA',
                                                                layout: 'form',
                                                                anchor: '99%',
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        layout: 'table',
                                                                        collapseFirst: false,
                                                                        collapsible: true,
                                                                        animCollapse: true,
                                                                        titleCollapse: true,
                                                                        anchor: '99%',
                                                                        autoHeight: true,
                                                                        layoutConfig: {
                                                                            columns: 1
                                                                        },
                                                                        items:[
                                                                            {
                                                                                xtype: 'textarea',
                                                                                width: 800,
                                                                                allowBlank: true,
                                                                                fieldLabel: 'AMA',
                                                                                name: 'AMA',
                                                                                id: 'memPacienteHC60'
                                                                            }
                                                                        ],
                                                                        tbar: {
                                                                            items: [
                                                                                {
                                                                                    xtype: 'tbseparator'
                                                                                },
                                                                                {
                                                                                    xtype: 'button',
                                                                                    iconCls: 'btnBuscar',
                                                                                    tooltip: 'Anexo AMA',
                                                                                    text: 'Anexo AMA',
                                                                                    listeners:{
                                                                                        click : function(){
                                                                                            var winAnexoAMA = new winAnexoAMAUi(); //RAFA
                                                                                            Ext.getCmp('sysCASAnexoAMA').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                                            Ext.getCmp('sysPacienteAnexoAMA').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                                            Ext.getCmp('sysProfesionalAnexoAMA').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                                            winAnexoAMA.show();
                                                                                        }
                                                                                    }
                                                                                },
                                                                                {
                                                                                    xtype: 'tbseparator'
                                                                                }
                                                                            ]
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Elasticidad (Retracciones)',
                                                                layout: 'table',
                                                                anchor: '99%',
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        width: 800,
                                                                        allowBlank: true,
                                                                        fieldLabel: 'Elasticidad (Retracciones)',
                                                                        name: 'Elasticidad (Retracciones)',
                                                                        id: 'memPacienteHC61'
                                                                    }
                                                                ]
                                                            },
                                                        ]
                                                    },
                                                    /*{
                                                        xtype: 'fieldset',
                                                        title: 'LONGITUD DE EXTREMIDADES',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'Miembro Superior',
                                                                layout: 'form',
                                                                collapseFirst: false,
                                                                collapsible: true,
                                                                animCollapse: true,
                                                                titleCollapse: true,
                                                                anchor: '99%',
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        autoHeight: true,
                                                                        autoScroll: true,
                                                                        anchor: '100%',
                                                                        frame: true,
                                                                        border: false,
                                                                        layout: 'table',
                                                                        layoutConfig: {
                                                                            columns: 3
                                                                        },
                                                                        items: [
                                                                            {
                                                                                xtype: 'panel',
                                                                                title: 'Derecho',
                                                                                width: 250,
                                                                                height: 100,
                                                                                autoScroll: true,
                                                                                anchor: '100%',
                                                                                frame: true,
                                                                                border: false,
                                                                                layout: 'form',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        anchor: '100%',
                                                                                        allowBlank: true,
                                                                                        fieldLabel: 'Real',
                                                                                        name: 'Real Der',
                                                                                        id: 'strPacienteHC70'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        anchor: '100%',
                                                                                        allowBlank: true,
                                                                                        fieldLabel: 'Aparente',
                                                                                        name: 'Aparente Der',
                                                                                        id: 'strPacienteHC71'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'panel',
                                                                                title: 'Izquierdo',
                                                                                width: 250,
                                                                                height: 100,
                                                                                autoScroll: true,
                                                                                anchor: '100%',
                                                                                frame: true,
                                                                                border: false,
                                                                                layout: 'form',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        anchor: '100%',
                                                                                        allowBlank: true,
                                                                                        fieldLabel: 'Real',
                                                                                        name: 'Real Izq',
                                                                                        id: 'strPacienteHC74'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        anchor: '100%',
                                                                                        allowBlank: true,
                                                                                        fieldLabel: 'Aparente',
                                                                                        name: 'Aparente Izq',
                                                                                        id: 'strPacienteHC75'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'panel',
                                                                                title: 'Diferencia',
                                                                                width: 250,
                                                                                height: 100,
                                                                                autoScroll: true,
                                                                                anchor: '100%',
                                                                                frame: true,
                                                                                border: false,
                                                                                layout: 'form',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        anchor: '100%',
                                                                                        allowBlank: true,
                                                                                        fieldLabel: 'Real',
                                                                                        name: 'Real Dif',
                                                                                        id: 'strPacienteHC77'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        anchor: '100%',
                                                                                        allowBlank: true,
                                                                                        fieldLabel: 'Aparente',
                                                                                        name: 'Aparente Dif',
                                                                                        id: 'strPacienteHC78'
                                                                                    }
                                                                                ]
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'textarea',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        fieldLabel: 'Interpretacion',
                                                                        name: 'Interpretacion',
                                                                        id: 'memPacienteHC80'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'Miembro Inferior',
                                                                layout: 'form',
                                                                collapseFirst: false,
                                                                collapsible: true,
                                                                animCollapse: true,
                                                                titleCollapse: true,
                                                                anchor: '99%',
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        autoHeight: true,
                                                                        autoScroll: true,
                                                                        anchor: '100%',
                                                                        frame: true,
                                                                        border: false,
                                                                        layout: 'table',
                                                                        layoutConfig: {
                                                                            columns: 3
                                                                        },
                                                                        items: [
                                                                            {
                                                                                xtype: 'panel',
                                                                                title: 'Derecho',
                                                                                width: 250,
                                                                                height: 100,
                                                                                autoScroll: true,
                                                                                anchor: '100%',
                                                                                frame: true,
                                                                                border: false,
                                                                                layout: 'form',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        anchor: '100%',
                                                                                        allowBlank: true,
                                                                                        fieldLabel: 'Real',
                                                                                        name: 'Real Der',
                                                                                        id: 'strPacienteHC81'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        anchor: '100%',
                                                                                        allowBlank: true,
                                                                                        fieldLabel: 'Aparente',
                                                                                        name: 'Aparente Der',
                                                                                        id: 'strPacienteHC82'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'panel',
                                                                                title: 'Izquierdo',
                                                                                width: 250,
                                                                                height: 100,
                                                                                autoScroll: true,
                                                                                anchor: '100%',
                                                                                frame: true,
                                                                                border: false,
                                                                                layout: 'form',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        anchor: '100%',
                                                                                        allowBlank: true,
                                                                                        fieldLabel: 'Real',
                                                                                        name: 'Real Izq',
                                                                                        id: 'strPacienteHC83'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        anchor: '100%',
                                                                                        allowBlank: true,
                                                                                        fieldLabel: 'Aparente',
                                                                                        name: 'Aparente Izq',
                                                                                        id: 'strPacienteHC84'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'panel',
                                                                                title: 'Diferencia',
                                                                                width: 250,
                                                                                height: 100,
                                                                                autoScroll: true,
                                                                                anchor: '100%',
                                                                                frame: true,
                                                                                border: false,
                                                                                layout: 'form',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        anchor: '100%',
                                                                                        allowBlank: true,
                                                                                        fieldLabel: 'Real',
                                                                                        name: 'Real Izq',
                                                                                        id: 'strPacienteHC85'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        anchor: '100%',
                                                                                        allowBlank: true,
                                                                                        fieldLabel: 'Aparente',
                                                                                        name: 'Aparente Izq',
                                                                                        id: 'strPacienteHC86'
                                                                                    }
                                                                                ]
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'textarea',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        fieldLabel: 'Interpretacion',
                                                                        name: 'Interpretacion',
                                                                        id: 'memPacienteHC87'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },*/
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'FUERZA MUSCULAR',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'table',
                                                                anchor: '99%',
                                                                autoHeight: true,
                                                                layoutConfig: {
                                                                    columns: 1
                                                                },
                                                                items:[
                                                                    {
                                                                        xtype: 'textarea',
                                                                        width: 800,
                                                                        allowBlank: true,
                                                                        fieldLabel: 'Fuerza Muscular',
                                                                        name: 'Fuerza Muscular',
                                                                        id: 'memPacienteHC100'
                                                                    }
                                                                ],
                                                                tbar: {
                                                                    items: [
                                                                        {
                                                                            xtype: 'tbseparator'
                                                                        },
                                                                        {
                                                                            xtype: 'button',
                                                                            iconCls: 'btnBuscar',
                                                                            tooltip: 'Anexo Examen Muscular MMSS',
                                                                            text: 'Anexo Examen Muscular MMSS',
                                                                            listeners:{
                                                                                click : function(){
                                                                                    var winAnexoExamenMuscularMMSS = new winAnexoExamenMuscularMMSSUi();
                                                                                    Ext.getCmp('sysCASAnexoMuscularMMSS').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                                    Ext.getCmp('sysPacienteAnexoMuscularMMSS').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                                    Ext.getCmp('sysProfesionalAnexoMuscularMMSS').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                                    winAnexoExamenMuscularMMSS.show();
                                                                                }
                                                                            }
                                                                        },
                                                                        {
                                                                            xtype: 'tbseparator'
                                                                        },
                                                                        {
                                                                            xtype: 'button',
                                                                            iconCls: 'btnBuscar',
                                                                            tooltip: 'Anexo Examen Muscular MMII',
                                                                            text: 'Anexo Examen Muscular MMII',
                                                                            listeners:{
                                                                                click : function(){
                                                                                    var winAnexoExamenMuscularMMII = new winAnexoExamenMuscularMMIIUi();
                                                                                    Ext.getCmp('sysCASAnexoExamenMuscularMMII').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                                    Ext.getCmp('sysPacienteAnexoMuscularMMII').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                                    Ext.getCmp('sysProfesionalAnexoMuscularMMII').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                                    winAnexoExamenMuscularMMII.show();
                                                                                }
                                                                            }
                                                                        },
                                                                        {
                                                                            xtype: 'tbseparator'
                                                                        },
                                                                        {
                                                                            xtype: 'button',
                                                                            iconCls: 'btnBuscar',
                                                                            tooltip: 'Anexo Escala Fuerza Muscular',
                                                                            text: 'Anexo Escala Fuerza Muscular',
                                                                            listeners:{
                                                                                click : function(){
                                                                                    var winAnexoEscalaFuerzaMuscular = new winAnexoEscalaFuerzaMuscularUi();
                                                                                    Ext.getCmp('sysCASAnexoEscalaFuerzaMuscular').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                                    Ext.getCmp('sysPacienteAnexoEscalaFuerzaMuscular').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                                    Ext.getCmp('sysProfesionalAnexoEscalaFuerzaMuscular').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                                    winAnexoEscalaFuerzaMuscular.show();
                                                                                }
                                                                            }
                                                                        },
                                                                        {
                                                                            xtype: 'tbseparator'
                                                                        }
                                                                    ]
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ALINEACION CORPORAL',
                                                        layout: 'table',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        tbar: {
                                                            items: [
                                                                {
                                                                    xtype: 'tbseparator'
                                                                },
                                                                {
                                                                    xtype: 'button',
                                                                    iconCls: 'btnBuscar',
                                                                    tooltip: 'Anexo Alineacion Postural',
                                                                    text: 'Anexo Alineacion Postural',
                                                                    listeners:{
                                                                        click : function(){
                                                                            var winAnexoAlineacionPostural = new winAnexoAlineacionPosturalUi();
                                                                            Ext.getCmp('sysCASAnexoAlineacionPostural').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                            Ext.getCmp('sysPacienteAnexoAlineacionPostural').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                            Ext.getCmp('sysProfesionalAnexoAlineacionPostural').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                            winAnexoAlineacionPostural.show();
                                                                        }
                                                                    }
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                }
                                                            ]
                                                        },
                                                        
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                width: 800,
                                                                allowBlank: true,
                                                                fieldLabel: 'Alineacion Corporal',
                                                                name: 'Alineacion Corporal',
                                                                id: 'memPacienteHC101'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'DEFORMIDADES',
                                                        layout: 'table',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                width: 800,
                                                                allowBlank: true,
                                                                fieldLabel: 'Deformidades',
                                                                name: 'Deformidades',
                                                                id: 'memPacienteHC102'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'AYUDAS EXTERNAS',
                                                        layout: 'table',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                width: 800,
                                                                allowBlank: true,
                                                                fieldLabel: 'Ayudas Externas',
                                                                name: 'Ayudas Externas',
                                                                id: 'memPacienteHC103'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'MARCHA',
                                                        layout: 'table',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                width: 800,
                                                                allowBlank: true,
                                                                fieldLabel: 'Marcha',
                                                                name: 'Marcha',
                                                                id: 'memPacienteHC104'
                                                            }
                                                        ]
                                                    },
                                                    /*{
                                                        xtype: 'fieldset',
                                                        title: 'OBSERVACIONES',
                                                        layout: 'table',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                width: 800,
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                fieldLabel: 'Observaciones',
                                                                id: 'memPacienteHC105'
                                                            }
                                                        ]
                                                    }*/
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                title: 'SISTEMA NEUROMUSCULAR',
                                                frame: true,
                                                anchor: '100%',
                                                padding: 10,
                                                border: false,
                                                autoHeight: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Estado de Conciencia',
                                                        name: 'Estado de Conciencia',
                                                        id: 'strPacienteHC106'
                                                    },
                                                    /*{
                                                        xtype: 'fieldset',
                                                        title: 'FUNCIONES MENTALES SUPERIORES',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Orientacion',
                                                                name: 'Orientacion',
                                                                id: 'strPacienteHC107'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Memoria',
                                                                name: 'Memoria',
                                                                id: 'strPacienteHC109'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Jucio',
                                                                name: 'Jucio',
                                                                id: 'strPacienteHC110'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Raciocinio',
                                                                name: 'Raciocinio',
                                                                id: 'strPacienteHC111'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Calculo',
                                                                name: 'Calculo',
                                                                id: 'strPacienteHC112'
                                                            }
                                                        ]
                                                    },*/
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Lenguaje',
                                                        name: 'Lenguaje',
                                                        id: 'strPacienteHC113'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Pares Craneales',
                                                        name: 'Pares Craneales',
                                                        id: 'strPacienteHC114'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'SENSIBILIDAD SUPERFICIAL',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Dermatomas',
                                                                name: 'Dermatomas',
                                                                id: 'strPacienteHC115'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Nervio Periferico',
                                                                name: 'Nervio Periferico',
                                                                id: 'strPacienteHC116'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'SENSIBILIDAD DISCRIMINATIVA',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Discriminacion de 2 puntos',
                                                                name: 'Discriminacion de 2 puntos',
                                                                id: 'strPacienteHC117'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Grafestesia',
                                                                name: 'Grafestesia',
                                                                id: 'strPacienteHC118'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Esterognosia',
                                                                name: 'Esterognosia',
                                                                id: 'strPacienteHC119'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'SENSIBILIDAD PROFUNDA',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Batiestesia',
                                                                name: 'Batiestesia',
                                                                id: 'strPacienteHC120'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Cinestesia',
                                                                name: 'Cinestesia',
                                                                id: 'strPacienteHC121'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Barestesia',
                                                                name: 'Barestesia',
                                                                id: 'strPacienteHC122'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Palestesia',
                                                                name: 'Palestesia',
                                                                id: 'strPacienteHC123'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'REFLEJOS OSTEOTENDINOSOS',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Bicipital',
                                                                name: 'Bicipital',
                                                                id: 'strPacienteHC124'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Estiloradial',
                                                                name: 'Estiloradial',
                                                                id: 'strPacienteHC125'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Tricipital',
                                                                name: 'Tricipital',
                                                                id: 'strPacienteHC126'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Rotuliano',
                                                                name: 'Rotuliano',
                                                                id: 'strPacienteHC127'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Aquiliano',
                                                                name: 'Aquiliano',
                                                                id: 'strPacienteHC128'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'REFLEJOS PATOLOGICOS',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Babinski',
                                                                name: 'Babinski',
                                                                id: 'strPacienteHC140'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Hoffman',
                                                                name: 'Hoffman',
                                                                id: 'strPacienteHC141'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Clonus',
                                                                name: 'Clonus',
                                                                id: 'strPacienteHC142'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'TONO MUSCULAR',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        tbar: {
                                                            items: [
                                                                {
                                                                    xtype: 'tbseparator'
                                                                },
                                                                {
                                                                    xtype: 'button',
                                                                    iconCls: 'btnBuscar',
                                                                    tooltip: 'Anexo Tono Muscular',
                                                                    text: 'Anexo Tono Muscular',
                                                                    listeners:{
                                                                        click : function(){
                                                                            var winAnexoEscalaAschworth = new winAnexoEscalaAschworthUi();
                                                                            Ext.getCmp('sysCASAnexoEscalaAschworth').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                            Ext.getCmp('sysPacienteAnexoEscalaAschworth').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                            Ext.getCmp('sysProfesionalAnexoEscalaAschworth').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                            winAnexoEscalaAschworth.show();
                                                                        }
                                                                    }
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                }
                                                            ]
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'Miembros Superiores',
                                                                layout: 'table',
                                                                collapseFirst: false,
                                                                collapsible: true,
                                                                animCollapse: true,
                                                                titleCollapse: true,
                                                                anchor: '99%',
                                                                autoHeight: true,
                                                                id: 'fs30_1',
                                                                tbar: {
                                                                    items: [
                                                                        {
                                                                            xtype: 'textarea',
                                                                            width: 800,
                                                                            allowBlank: true,
                                                                            fieldLabel: 'Miembros Superiores',
                                                                            name: 'Miembros Superiores',
                                                                            id: 'memPacienteHC143'
                                                                        }
                                                                    ]
                                                                }
                                                            },
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'Miembros Inferiores',
                                                                layout: 'table',
                                                                collapseFirst: false,
                                                                collapsible: true,
                                                                animCollapse: true,
                                                                titleCollapse: true,
                                                                anchor: '99%',
                                                                autoHeight: true,
                                                                tbar: {
                                                                    items: [
                                                                        {
                                                                            xtype: 'textarea',
                                                                            width: 800,
                                                                            allowBlank: true,
                                                                            fieldLabel: 'Miembros Inferiores',
                                                                            name: 'Miembros Inferiores',
                                                                            id: 'memPacienteHC144'
                                                                        }
                                                                    ]
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Funcion Motora',
                                                        name: 'Funcion Motora',
                                                        id: 'strPacienteHC145'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Sinergias',
                                                        name: 'Sinergias',
                                                        id: 'strPacienteHC146'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Sincinesias',
                                                        name: 'Sincinesias',
                                                        id: 'strPacienteHC147'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'DESARROLLO DEL NIÑO',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'Reflejos Presentes',
                                                                layout: 'table',
                                                                collapseFirst: false,
                                                                collapsible: true,
                                                                animCollapse: true,
                                                                titleCollapse: true,
                                                                anchor: '99%',
                                                                autoHeight: true,
                                                                tbar: {
                                                                    items: [
                                                                        {
                                                                            xtype: 'tbseparator'
                                                                        },
                                                                        {
                                                                            xtype: 'button',
                                                                            iconCls: 'btnBuscar',
                                                                            tooltip: 'Anexo Reflejos - Neurodesarrollo',
                                                                            text: 'Anexo Reflejos - Neurodesarrollo',
                                                                            listeners:{
                                                                                click : function(){
                                                                                    var winAnexoReflejosNeuroDesarrollo = new winAnexoReflejosNeuroDesarrolloUi();
                                                                                    Ext.getCmp('sysCASAnexoReflejosNeuroDesarrollo').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                                    Ext.getCmp('sysPacienteAnexoReflejosNeuroDesarrollo').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                                    Ext.getCmp('sysProfesionalAnexoReflejosNeuroDesarrollo').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                                    winAnexoReflejosNeuroDesarrollo.show();
                                                                                }
                                                                            }
                                                                        },
                                                                        {
                                                                            xtype: 'tbseparator'
                                                                        }
                                                                    ]
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 800,
                                                                        allowBlank: true,
                                                                        fieldLabel: 'Reflejos Presentes',
                                                                        name: 'Reflejos Presentes',
                                                                        id: 'strPacienteHC148'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Reflejos Integrados',
                                                                name: 'Reflejos Integrados',
                                                                id: 'strPacienteHC149'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Conductas Motoras',
                                                                name: 'Conductas Motoras',
                                                                id: 'strPacienteHC150'
                                                            }
                                                        ]
                                                    },
                                                    /*{
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Esquema Corporal',
                                                        name: 'Esquema Corporal',
                                                        id: 'strPacienteHC153'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'LATERALIDAD',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                allowBlank: true,
                                                                fieldLabel: 'Ocular',
                                                                name: 'Ocular',
                                                                id: 'strPacienteHC154'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                allowBlank: true,
                                                                fieldLabel: 'Auditiva',
                                                                name: 'Auditiva',
                                                                id: 'strPacienteHC155'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                allowBlank: true,
                                                                fieldLabel: 'Manual',
                                                                name: 'Manual',
                                                                id: 'strPacienteHC156'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                allowBlank: true,
                                                                fieldLabel: 'Pedal',
                                                                name: 'Pedal',
                                                                id: 'strPacienteHC157'
                                                            }
                                                        ]
                                                    },*/
                                                    /*{
                                                        xtype: 'fieldset',
                                                        title: 'EQUILIBRIO ESTATICO',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                allowBlank: true,
                                                                fieldLabel: 'Apoyo Bipodal',
                                                                name: 'Apoyo Bipodal',
                                                                id: 'strPacienteHC161'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                allowBlank: true,
                                                                fieldLabel: 'En diferentes Posiciones',
                                                                name: 'En diferentes Posiciones',
                                                                id: 'strPacienteHC162'
                                                            }
                                                        ]
                                                    },*/
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Equilibrio Estatico',
                                                        name: 'Equilibrio Estatico',
                                                        id: 'strPacienteHC163A'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Equilibrio Dinamico',
                                                        name: 'Equilibrio Dinamico',
                                                        id: 'strPacienteHC163'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Reacciones Protectivas',
                                                        name: 'Reacciones Protectivas',
                                                        id: 'strPacienteHC164'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'COORDINACION',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Coordinacion Oculomanual',
                                                                name: 'Coordinacion Oculomanual',
                                                                id: 'strPacienteHC165'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Coordinacion Oculopedial',
                                                                name: 'Coordinacion Oculopedial',
                                                                id: 'strPacienteHC166'
                                                            }
                                                        ]
                                                    },
                                                    /*{
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Praxias Finas',
                                                        name: 'Praxias Finas',
                                                        id: 'strPacienteHC167'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        id: 'memPacienteHC168'
                                                    }*/
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                title: 'SISTEMA TEGUMENTARIO',
                                                frame: true,
                                                anchor: '100%',
                                                padding: 10,
                                                border: false,
                                                autoHeight: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Estado de la Piel',
                                                        name: 'Estado de la Piel',
                                                        id: 'strPacienteHC169'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Cicatrices',
                                                        name: 'Cicatrices',
                                                        id: 'strPacienteHC170'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Cambios de la Coloracion',
                                                        name: 'Cambios de la Coloracion',
                                                        id: 'strPacienteHC171'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Temperatura',
                                                        name: 'Temperatura',
                                                        id: 'strPacienteHC172'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Consistencia',
                                                        name: 'Consistencia',
                                                        id: 'strPacienteHC173'
                                                    }
                                                ]
                                            },
                                            /*{
                                                xtype: 'panel',
                                                title: 'ACTIVIDADES DIARIAS COTIDIANAS',
                                                layout: 'table',
                                                frame: true,
                                                anchor: '100%',
                                                padding: 10,
                                                border: false,
                                                autoHeight: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '98%',
                                                        width: 800,
                                                        allowBlank: true,
                                                        fieldLabel: 'ACTIVIDADES DIARIAS COTIDIANAS',
                                                        name: 'ACTIVIDADES DIARIAS COTIDIANAS',
                                                        id: 'memPacienteHC173a'
                                                    }
                                                ]
                                            },*/
                                            /*{
                                                xtype: 'panel',
                                                layout: 'form',
                                                title: 'DIAGNOSTICO FISIOTERAPEUTICO',
                                                frame: true,
                                                anchor: '100%',
                                                padding: 10,
                                                border: false,
                                                autoHeight: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'APTA',
                                                        name: 'APTA',
                                                        id: 'strPacienteHC174'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'CIF',
                                                        name: 'CIF',
                                                        id: 'strPacienteHC175'
                                                    }
                                                ]
                                            },*/
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                title: 'OBJETIVOS DE TRATAMIENTO',
                                                frame: true,
                                                anchor: '100%',
                                                padding: 10,
                                                border: false,
                                                autoHeight: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '98%',
                                                        width: 800,
                                                        allowBlank: true,
                                                        fieldLabel: 'OBJETIVOS DE TRATAMIENTO',
                                                        name: 'OBJETIVOS DE TRATAMIENTO',
                                                        id: 'memPacienteHC175b'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'OTROS ANEXOS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                tbar: {
                                                    items: [
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            iconCls: 'btnBuscar',
                                                            tooltip: 'Funcion de los Musculos Faciales',
                                                            text: 'Funcion de los Musculos Faciales',
                                                            listeners:{
                                                                click : function(){
                                                                    var winAnexoEvaluacionFuncionMusculosFaciales = new winAnexoEvaluacionFuncionMusculosFacialesUi();
                                                                    Ext.getCmp('sysCASAnexoEvaluacionFuncionMusculosFaciales').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                    Ext.getCmp('sysPacienteAnexoEvaluacionFuncionMusculosFaciales').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                    Ext.getCmp('sysProfesionalAnexoEvaluacionFuncionMusculosFaciales').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                    winAnexoEvaluacionFuncionMusculosFaciales.show();
                                                                }
                                                            }
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            iconCls: 'btnBuscar',
                                                            tooltip: 'E. Articulacion Temporo Mandibular',
                                                            text: 'E. Articulacion Temporo Mandibular',
                                                            listeners:{
                                                                click : function(){
                                                                    var winAnexoEvaluacionCraneoMandibular = new winAnexoEvaluacionCraneoMandibularUi();
                                                                    Ext.getCmp('sysCASAnexoEvaluacionCraneoMandibular').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                    Ext.getCmp('sysPacienteAnexoEvaluacionCraneoMandibular').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                    Ext.getCmp('sysProfesionalAnexoEvaluacionCraneoMandibular').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                    winAnexoEvaluacionCraneoMandibular.show();
                                                                }
                                                            }
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            iconCls: 'btnBuscar',
                                                            tooltip: 'Escala de Percepcion de Esfuerzo',
                                                            text: 'Escala de Percepcion de Esfuerzo',
                                                            listeners:{
                                                                click : function(){
                                                                    var winAnexoEscalaPerscepcionEsfuerzo = new winAnexoEscalaPerscepcionEsfuerzoUi();
                                                                    Ext.getCmp('sysCASAnexoEvaluacionCraneoMandibular').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                    Ext.getCmp('sysPacienteAnexoEvaluacionCraneoMandibular').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                    Ext.getCmp('sysProfesionalAnexoEvaluacionCraneoMandibular').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                    winAnexoEscalaPerscepcionEsfuerzo.show();
                                                                }
                                                            }
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        }
                                                    ]
                                                }
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ],
                                        bbar:{
                                            items: [
                                                {
                                                    xtype: 'tbfill'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Salir',
                                                    iconCls: 'btnSalir',
                                                    id: 'btnSalirEvolucion',
                                                    listeners:{
                                                        click : function(){
                                                            if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                                                Ext.Msg.show({
                                                                    title: 'eOfiClinic',
                                                                    msg: 'Esta seguro que desea cerrar la ventana?',
                                                                    buttons: Ext.Msg.YESNO,
                                                                    icon: Ext.Msg.QUESTION,
                                                                    fn: function(btn)
                                                                    {
                                                                        if(btn=="yes")
                                                                        {
                                                                            Ext.getCmp('gridFormulario').store.reload();
                                                                            Ext.getCmp('winHC').close();
                                                                        }
                                                                    }
                                                                });
                                                            else{
                                                                Ext.Msg.show({
                                                                    title: 'eOfiClinic',
                                                                    msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                                                    buttons: Ext.Msg.YESNO,
                                                                    icon: Ext.Msg.QUESTION,
                                                                    fn: function(btn)
                                                                    {
                                                                        if(btn=="yes")
                                                                        {
                                                                            Ext.getCmp('gridFormulario').store.reload();
                                                                            Ext.getCmp('winHC').close();
                                                                        }
                                                                    }
                                                                });
                                                            }
                                                        }
                                                    }
                                                }
                                            ]
                                        },
                                        tbar:{
                                            items: [
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Ver Historia Clínica',
                                                    iconCls: 'btnVerHC',
                                                    id: 'btnVerHC',
                                                    listeners:{
                                                        click : function(){
                                                            var cmpResumenHC = new winFrmVerHistorialHC({
                                                                renderTo: Ext.getBody()
                                                            });
                                                            Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                                            Ext.getCmp('gridHistorialEvoluciones').store.load({
                                                                params: {
                                                                    pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                                                    pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                                                }
                                                            });
                                                            cmpResumenHC.show();
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbfill'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Guardar Evolución',
                                                    iconCls: 'btnGuardar',
                                                    id: 'btnGuardarEvolucion',
                                                    listeners:{
                                                        click : function(){
                                                            if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                                            {
                                                                Ext.Msg.show({
                                                                    title: 'eOfiClinic',
                                                                    msg: 'Esta seguro que desea Guardar la evolución?',
                                                                    buttons: Ext.Msg.YESNO,
                                                                    icon: Ext.Msg.QUESTION,
                                                                    fn: function(btn)
                                                                    {
                                                                        if(btn=="yes")
                                                                        {
                                                                            fnGuardarRegistros();
                                                                        }
                                                                    }
                                                                });
                                                            }else{
                                                                Ext.Msg.show({
                                                                    title: 'eOfiClinic',
                                                                    msg: 'Esta seguro que desea Modificar la evolución?',
                                                                    buttons: Ext.Msg.YESNO,
                                                                    icon: Ext.Msg.QUESTION,
                                                                    fn: function(btn)
                                                                    {
                                                                        if(btn=="yes")
                                                                        {
                                                                            fnModificarRegistros();
                                                                        }
                                                                    }
                                                                });
                                                            }
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
        winHCFisioterapia001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

