/*
* @category    Formulario Modelo Evolucion Historia Clinica Gestantes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCGestante001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC Gestantes::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        var fsDiagnosticosConsulta = new fsDiagnosticosConsultaUi();
        var fsRevisionxSistemas = new fsRevisionxSistemasUi();
        var fsAntecedentesPersonales = new fsAntecedentesPersonalesUi();
        var fsAntecedentesFamiliares = new fsAntecedentesFamiliaresUi();
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }

        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'INFORMACION',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaIdentifica',
                                layout: 'form',
                                items:[
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroHC'
                                            },
                                            {
                                                html: 'Fecha Nac:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Edad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 350,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEdadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 96,
                                                allowBlank: false,
                                                fieldLabel: 'Ocupacion',
                                                id: 'sysOcupacionHC'
                                            },
                                            {
                                                xtype: 'textarea',
                                                readOnly: true,
                                                width: 695,
                                                height: 22,
                                                id: 'sysOcupacionHCNom'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Ocupacion',
                                                id: 'btnSearchOcupacionHC',
                                                listeners:{
                                                    click : function(){
                                                        buscarciuo('sysOcupacionHC','sysOcupacionHCNom');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Etnia',
                                                name: 'Etnia',
                                                width: 370,
                                                allowBlank: false,
                                                store: 'StoreEtnia4505',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'sysEtniaHC'
                                            },
                                            {
                                                html: 'Escolaridad:'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Escolaridad',
                                                width: 380,
                                                allowBlank: false,
                                                store: 'StoreEscolaridad4505',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'sysEscolaridadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Estado Civil',
                                                id: 'sysEstadoCivilHC'
                                            },
                                            {
                                                html: 'Discapacidad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysDiscapacidadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Dirección',
                                                id: 'sysDireccionHC'
                                            },
                                            {
                                                html: 'Telefono:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysTelefonoHC'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Acompañante',
                                                        name: 'Acompañante',
                                                        width: 350,
                                                        allowBlank: true,
                                                        id: 'strDATINGPROGAcompanante'
                                                    },
                                                    {
                                                        html: '   Parentesco:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Parentezco',
                                                        width: 350,
                                                        allowBlank: true,
                                                        store: stParentesco,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strDATINGPROGParentesco'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ENFERMEDAD ACTUAL',
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEnfermedadActual'
                                                    }
                                                ]
                                            },
                                            fsRevisionxSistemas,
                                            fsAntecedentesPersonales,
                                            fsAntecedentesFamiliares,
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                padding: 0,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'T.A. (Sentado)<br>&nbsp;',
                                                                name: 'T.A. (Sentado) Sistolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intEXAFISTASentadoSistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. (Sentado) Diastolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intEXAFISTASentadoDiastolica'
                                                            },
                                                            {
                                                                html: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
                                                            },
                                                            {
                                                                html: 'T.A. (de Pie)'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. (de Pie) Sistolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intEXAFISTAdePieSistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. (de Pie) Diastolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intEXAFISTAdePieDiastolica'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                fieldLabel: 'TALLA (cm)<br>&nbsp;',
                                                                name:"TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEXAFISTalla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEXAFISTalla').setValue(null);
                                                                            Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISPeso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                            }
                                                                        }
                                                                       if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ SEVERA");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                                                        }else{
                                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                                                                }else{
                                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                                                                    }else{
                                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                                                        Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISPeso',
                                                                value: 'PESO (Kg) '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                emptyText: '(Kg)',
                                                                name:"PESO (Kg)",
                                                                id: 'intEXAFISPeso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEXAFISPeso').setValue(null);
                                                                            Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEXAFISTalla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DESGADEZ SEVERA");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                                                        }else{
                                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                                                                }else{
                                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                                                                    }else{
                                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                                                        Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISIMC',
                                                                value: 'IMC '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                readOnly: true,
                                                                name: "IMC",
                                                                id: 'intEXAFISIMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: false,
                                                                readOnly: true,
                                                                name: "IMC - CLASIFICACION",
                                                                id: 'strEXAFISIMCClasificacon'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'Temp<br>&nbsp;',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'Temperatura',
                                                                allowBlank: false,
                                                                id: 'intEXAFISTemp'
                                                            },
                                                            {
                                                                html: 'F.C.'
                                                            },                                                            
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'FC',
                                                                allowBlank: false,
                                                                id: 'intEXAFISFC'
                                                            },
                                                            {
                                                                html: 'F.R.'
                                                            },                                                            
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'FR',
                                                                allowBlank: false,
                                                                id: 'intEXAFISFR'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Altura Uterina',
                                                                fieldLabel: 'Altura Uterina<br>&nbsp;',
                                                                width: 70,
                                                                allowBlank: false,
                                                                id: 'intAlturaUterina'
                                                            },
                                                            {
                                                                html: 'Fetocardia Audible?'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                forceSelection: true,
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                name:'Fetocardia Audible?',
                                                                id: 'strFetocardiaAudible',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('intFetocardia').allowBlank = true;
                                                                            Ext.getCmp('intFetocardia').disable();
                                                                            Ext.getCmp('intFetocardia').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('intFetocardia').enable();
                                                                            Ext.getCmp('intFetocardia').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Fetocardia',
                                                                emptyText: '(x Minuto)',
                                                                width: 70,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'intFetocardia'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Presentacion',
                                                                fieldLabel: 'Presentacion<br>&nbsp;',
                                                                width: 90,
                                                                allowBlank: true,
                                                                store: stPresentacion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTPresentacion'
                                                            },
                                                            {
                                                                html: 'Mov. Fetales'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Mov. Fetales',
                                                                width: 70,
                                                                allowBlank: true,
                                                                id: 'strGESTMovFetales'
                                                            },
                                                            {
                                                                html: 'Estado Nutricional'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Estado Nutricional',
                                                                width: 90,
                                                                allowBlank: true,
                                                                id: 'strGESTEstadoNutricional'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Condiciones Generales',
                                                        name: 'Condiciones Generales',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISCondicionesGenerales',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCondicionesGenerales').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cabeza<br>&nbsp;',
                                                        name: 'Cabeza',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISCabeza',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCabeza').setValue("Normal");
                                                                });
                                                            }
                                                        }

                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Ojos<br>&nbsp;',
                                                        name: 'Ojos',
                                                        allowBlank: false,
                                                        id: 'strEXAFISOjos',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISOjos').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Nariz<br>&nbsp;',
                                                        name: 'Nariz',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISNariz',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISNariz').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Orofaringe<br>&nbsp;',
                                                        name: 'Orofaringe',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISOrofaringe',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISOrofaringe').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cuello<br>&nbsp;',
                                                        name: 'Cuello',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISCuello',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCuello').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Valoracion Mamaria',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 7,
                                                        id: 'fsEXAMFISValMamaria',
                                                        items:[
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Aspecto',
                                                                name: 'Aspecto',
                                                                allowBlank: true,
                                                                id: 'strEXAFISMamaAspecto',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISMamaAspecto').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Ganglios',
                                                                name: 'Ganglios',
                                                                allowBlank: true,
                                                                id: 'strEXAFISMamaGanglios',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISMamaGanglios').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Malestar',
                                                                name: 'Malestar',
                                                                allowBlank: true,
                                                                id: 'strEXAFISMamaMalestar',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISMamaMalestar').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Dolores',
                                                                name: 'Dolores',
                                                                allowBlank: true,
                                                                id: 'strEXAFISMamaDolor',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISMamaDolor').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Descargas',
                                                                name: 'Descargas',
                                                                allowBlank: true,
                                                                id: 'strEXAFISMamaDescargas',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISMamaDescargas').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Masas o Bultos',
                                                                name: 'Masas o Bultos',
                                                                allowBlank: true,
                                                                id: 'strEXAFISMamaMasas',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISMamaMasas').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Dorso<br>&nbsp;',
                                                        name: 'Dorso',
                                                        allowBlank: false,
                                                        id: 'strEXAFISDorso',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISDorso').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cardiaco<br>&nbsp;',
                                                        name: 'Cardiaco',
                                                        allowBlank: false,
                                                        id: 'strEXAFISCardiaco',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCardiaco').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Pulmonar<br>&nbsp;',
                                                        name: 'Pulmonar',
                                                        allowBlank: false,
                                                        id: 'strEXAFISPulmonar',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISPulmonar').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Abdomen<br>&nbsp;',
                                                        name: 'Abdomen',
                                                        allowBlank: false,
                                                        id: 'strEXAFISAbdomen',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISAbdomen').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Genitales<br>&nbsp;',
                                                        name: 'Genitales',
                                                        allowBlank: false,
                                                        id: 'strEXAFISGenitales',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISGenitales').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Extremidades<br>&nbsp;',
                                                        name: 'Extremidades',
                                                        allowBlank: false,
                                                        id: 'strEXAFISExtremidades',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISExtremidades').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Neurologico<br>&nbsp;',
                                                        name: 'Neurologico',
                                                        allowBlank: false,
                                                        id: 'strEXAFISNeurologico',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISNeurologico').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EDAD DE GESTACION CONFIABLE',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'FUM',
                                                                fieldLabel: 'FUM',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTEdadGestFUM'
                                                            },
                                                            {
                                                                html: 'Edad Segun FUM'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Edad Segun FUM',
                                                                width: 130,
                                                                minValue: 0,
                                                                maxValue: 70,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intEdadGestacionalFum',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue <= 13 && Ext.getCmp('strGESTEdadGestFUM').getValue() == "SI"){
                                                                            Ext.getCmp('strTrimestreFUM').setValue("Primer Trimestre");
                                                                            Ext.getCmp('fsExamenesPrimerTrimestre').setVisible(true);
                                                                                Ext.getCmp('fsExamenesSegundoTrimestre').setVisible(false);
                                                                                Ext.getCmp('fsExamenesTercerTrimestre').setVisible(false);
                                                                        }else{
                                                                            if(newValue >= 27 && Ext.getCmp('strGESTEdadGestFUM').getValue() == "SI"){
                                                                                Ext.getCmp('strTrimestreFUM').setValue("Tercer Trimestre");
                                                                                Ext.getCmp('fsExamenesPrimerTrimestre').setVisible(true);
                                                                                Ext.getCmp('fsExamenesSegundoTrimestre').setVisible(true);
                                                                                Ext.getCmp('fsExamenesTercerTrimestre').setVisible(true);
                                                                            }else{
                                                                                if(newValue >= 14 && newValue <= 26 && Ext.getCmp('strGESTEdadGestFUM').getValue() == "SI"){
                                                                                    Ext.getCmp('strTrimestreFUM').setValue("Segundo Trimestre");
                                                                                    Ext.getCmp('fsExamenesPrimerTrimestre').setVisible(true);
                                                                                    Ext.getCmp('fsExamenesSegundoTrimestre').setVisible(true);
                                                                                    Ext.getCmp('fsExamenesTercerTrimestre').setVisible(false);
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Trimestre'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name:'Trimestre',
                                                                id: 'strTrimestreFUM'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Eco. < 20s',
                                                                fieldLabel: 'Eco. < 20s',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTEdadGestEco'
                                                            },
                                                            {
                                                                html: 'Edad Segun Eco'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Edad Segun Eco',
                                                                width: 130,
                                                                minValue: 0,
                                                                maxValue: 70,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intEdadGestacionalEco',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue <= 13 && Ext.getCmp('strGESTEdadGestEco').getValue() == "SI"){
                                                                            Ext.getCmp('strTrimestreEco').setValue("Primer Trimestre");
                                                                            Ext.getCmp('fsExamenesPrimerTrimestre').setVisible(true);
                                                                            Ext.getCmp('fsExamenesSegundoTrimestre').setVisible(false);
                                                                            Ext.getCmp('fsExamenesTercerTrimestre').setVisible(false);
                                                                        }else{
                                                                            if(newValue >= 27 && Ext.getCmp('strGESTEdadGestEco').getValue() == "SI"){
                                                                                Ext.getCmp('strTrimestreEco').setValue("Tercer Trimestre");
                                                                                Ext.getCmp('fsExamenesPrimerTrimestre').setVisible(true);
                                                                                Ext.getCmp('fsExamenesSegundoTrimestre').setVisible(true);
                                                                                Ext.getCmp('fsExamenesTercerTrimestre').setVisible(true);
                                                                            }else{
                                                                                if(newValue >= 14 && newValue <= 26 && Ext.getCmp('strGESTEdadGestEco').getValue() == "SI"){
                                                                                    Ext.getCmp('strTrimestreEco').setValue("Segundo Trimestre");
                                                                                    Ext.getCmp('fsExamenesPrimerTrimestre').setVisible(true);
                                                                                    Ext.getCmp('fsExamenesSegundoTrimestre').setVisible(true);
                                                                                    Ext.getCmp('fsExamenesTercerTrimestre').setVisible(false);
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Trimestre'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name:'Trimestre',
                                                                id: 'strTrimestreEco'
                                                            }
                                                        ]
                                                    },

                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Examenes Ingreso',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                id: 'fsExamenesPrimerTrimestre',
                                                items: [
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Hemoclasificacion',
                                                                fieldLabel: 'Hemoclasificacion',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTHemocla',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTHemoclasificacionDescripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTHemoclasificacionFecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTHemoclasificacionDescripcion').disable();
                                                                            Ext.getCmp('fecGESTHemoclasificacionFecha').disable();
                                                                            Ext.getCmp('strGESTHemoclasificacionDescripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTHemoclasificacionFecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTHemoclasificacionDescripcion').enable();
                                                                            Ext.getCmp('fecGESTHemoclasificacionFecha').enable();
                                                                            Ext.getCmp('strGESTHemoclasificacionDescripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTHemoclasificacionFecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Hemoclasificacion Descripcion',
                                                                id: 'strGESTHemoclasificacionDescripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Hemoclasificacion Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTHemoclasificacionFecha'
                                                            }
                                                        ]
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'VIH',
                                                                fieldLabel: 'VIH',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTVIH',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTVIHDescripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTVIHFecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTVIHDescripcion').disable();
                                                                            Ext.getCmp('fecGESTVIHFecha').disable();
                                                                            Ext.getCmp('strGESTVIHDescripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTVIHFecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTVIHDescripcion').enable();
                                                                            Ext.getCmp('fecGESTVIHFecha').enable();
                                                                            Ext.getCmp('strGESTVIHDescripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTVIHFecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'VIH Descripcion',
                                                                id: 'strGESTVIHDescripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'VIH Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTVIHFecha'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'VIH Consejeria',
                                                        fieldLabel: 'VIH Consejeria',
                                                        width: 60,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strGESTVIHConsejeria'
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Uroanalisis',
                                                                fieldLabel: 'Uroanalisis',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTUroanalisis',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTUroanalisisDescripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTUroanalisisFecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTUroanalisisDescripcion').disable();
                                                                            Ext.getCmp('fecGESTUroanalisisFecha').disable();
                                                                            Ext.getCmp('strGESTUroanalisisDescripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTUroanalisisFecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTUroanalisisDescripcion').enable();
                                                                            Ext.getCmp('fecGESTUroanalisisFecha').enable();
                                                                            Ext.getCmp('strGESTUroanalisisDescripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTUroanalisisFecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Uroanalisis Descripcion',
                                                                id: 'strGESTUroanalisisDescripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Uroanalisis Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTUroanalisisFecha'
                                                            }
                                                        ]
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Hb < 14 sem',
                                                                fieldLabel: 'Hb < 14 sem',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTHb',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTHbDescripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTHbFecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTHbDescripcion').disable();
                                                                            Ext.getCmp('fecGESTHbFecha').disable();
                                                                            Ext.getCmp('strGESTHbDescripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTHbFecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTHbDescripcion').enable();
                                                                            Ext.getCmp('fecGESTHbFecha').enable();
                                                                            Ext.getCmp('strGESTHbDescripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTHbFecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Hb Descripcion',
                                                                id: 'strGESTHbDescripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Hb Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTHbFecha'
                                                            }
                                                        ]
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'VDRL < 14 Sem',
                                                                fieldLabel: 'VDRL < 14 Sem',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTVDRL',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTVDRLDescripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTVDRLFecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTVDRLDescripcion').disable();
                                                                            Ext.getCmp('fecGESTVDRLFecha').disable();
                                                                            Ext.getCmp('strGESTVDRLDescripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTVDRLFecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTVDRLDescripcion').enable();
                                                                            Ext.getCmp('fecGESTVDRLFecha').enable();
                                                                            Ext.getCmp('strGESTVDRLDescripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTVDRLFecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'VDRL Descripcion',
                                                                id: 'strGESTVDRLDescripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'VDRL Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTVDRLFecha'
                                                            }
                                                        ]
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Eco < 14 Sem',
                                                                fieldLabel: 'Eco < 14 Sem',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTEcografia',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTEcografiaDescripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTEcografiaFecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTEcografiaDescripcion').disable();
                                                                            Ext.getCmp('fecGESTEcografiaFecha').disable();
                                                                            Ext.getCmp('strGESTEcografiaDescripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTEcografiaFecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTEcografiaDescripcion').enable();
                                                                            Ext.getCmp('fecGESTEcografiaFecha').enable();
                                                                            Ext.getCmp('strGESTEcografiaDescripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTEcografiaFecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Ecografia Descripcion',
                                                                id: 'strGESTEcografiaDescripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Ecografia Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTEcografiaFecha'
                                                            }
                                                        ]
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Gram',
                                                                fieldLabel: 'Gram',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTGram1',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTGram1Descripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTGram1Fecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTGram1Descripcion').disable();
                                                                            Ext.getCmp('fecGESTGram1Fecha').disable();
                                                                            Ext.getCmp('strGESTGram1Descripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTGram1Fecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTGram1Descripcion').enable();
                                                                            Ext.getCmp('fecGESTGram1Fecha').enable();
                                                                            Ext.getCmp('strGESTGram1Descripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTGram1Fecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Gram Descripcion',
                                                                id: 'strGESTGram1Descripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Gram Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTGram1Fecha'
                                                            }
                                                        ]
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Hemograma',
                                                                fieldLabel: 'Hemograma',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTCH1',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTCH1Descripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTCH1Fecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTCH1Descripcion').disable();
                                                                            Ext.getCmp('fecGESTCH1Fecha').disable();
                                                                            Ext.getCmp('strGESTCH1Descripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTCH1Fecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTCH1Descripcion').enable();
                                                                            Ext.getCmp('fecGESTCH1Fecha').enable();
                                                                            Ext.getCmp('strGESTCH1Descripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTCH1Fecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Hemograma Descripcion',
                                                                id: 'strGESTCH1Descripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Hemograma Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTCH1Fecha'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Examenes Segundo Trimestre',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                id: 'fsExamenesSegundoTrimestre',
                                                items: [
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Uroanalisis',
                                                                fieldLabel: 'Uroanalisis',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTUroanalisis2',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTUroanalisis2Descripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTUroanalisis2Fecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTUroanalisis2Descripcion').disable();
                                                                            Ext.getCmp('fecGESTUroanalisis2Fecha').disable();
                                                                            Ext.getCmp('strGESTUroanalisis2Descripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTUroanalisis2Fecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTUroanalisis2Descripcion').enable();
                                                                            Ext.getCmp('fecGESTUroanalisis2Fecha').enable();
                                                                            Ext.getCmp('strGESTUroanalisis2Descripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTUroanalisis2Fecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Uroanalisis Descripcion',
                                                                id: 'strGESTUroanalisis2Descripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Uroanalisis Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTUroanalisis2Fecha'
                                                            }
                                                        ]
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Test O Sullivan',
                                                                fieldLabel: 'Test O Sullivan',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTTest',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTTestDescripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTTestFecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTTestDescripcion').disable();
                                                                            Ext.getCmp('fecGESTTestFecha').disable();
                                                                            Ext.getCmp('strGESTTestDescripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTTestFecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTTestDescripcion').enable();
                                                                            Ext.getCmp('fecGESTTestFecha').enable();
                                                                            Ext.getCmp('strGESTTestDescripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTTestFecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Test O Sullivan Descripcion',
                                                                id: 'strGESTTestDescripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Test O Sullivan Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTTestFecha'
                                                            }
                                                        ]
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Eco 19 - 24 Sem',
                                                                fieldLabel: 'Eco 19 - 24 Sem',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTEcografia2',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTEcografia2Descripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTEcografia2Fecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTEcografia2Descripcion').disable();
                                                                            Ext.getCmp('fecGESTEcografia2Fecha').disable();
                                                                            Ext.getCmp('strGESTEcografia2Descripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTEcografia2Fecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTEcografia2Descripcion').enable();
                                                                            Ext.getCmp('fecGESTEcografia2Fecha').enable();
                                                                            Ext.getCmp('strGESTEcografia2Descripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTEcografia2Fecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Ecografia 19 - 24 Sem Descripcion',
                                                                id: 'strGESTEcografia2Descripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Ecografia 19 - 24 Sem Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTEcografia2Fecha'
                                                            }
                                                        ]
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Gram',
                                                                fieldLabel: 'Gram',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTGram2',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTGram2Descripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTGram2Fecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTGram2Descripcion').disable();
                                                                            Ext.getCmp('fecGESTGram2Fecha').disable();
                                                                            Ext.getCmp('strGESTGram2Descripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTGram2Fecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTGram2Descripcion').enable();
                                                                            Ext.getCmp('fecGESTGram2Fecha').enable();
                                                                            Ext.getCmp('strGESTGram2Descripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTGram2Fecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Gram Descripcion',
                                                                id: 'strGESTGram2Descripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Gram Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTGram2Fecha'
                                                            }
                                                        ]
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Hemograma',
                                                                fieldLabel: 'Hemograma',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTCH2',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTCH2Descripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTCH2Fecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTCH2Descripcion').disable();
                                                                            Ext.getCmp('fecGESTCH2Fecha').disable();
                                                                            Ext.getCmp('strGESTCH2Descripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTCH2Fecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTCH2Descripcion').enable();
                                                                            Ext.getCmp('fecGESTCH2Fecha').enable();
                                                                            Ext.getCmp('strGESTCH2Descripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTCH2Fecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Hemograma Descripcion',
                                                                id: 'strGESTCH2Descripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Hemograma Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTCH2Fecha'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Examenes Tercer Trimestre',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                id: 'fsExamenesTercerTrimestre',
                                                items: [
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Uroanalisis',
                                                                fieldLabel: 'Uroanalisis',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTUroanalisis3',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTUroanalisis3Descripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTUroanalisis3Fecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTUroanalisis3Descripcion').disable();
                                                                            Ext.getCmp('fecGESTUroanalisis3Fecha').disable();
                                                                            Ext.getCmp('strGESTUroanalisis3Descripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTUroanalisis3Fecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTUroanalisis3Descripcion').enable();
                                                                            Ext.getCmp('fecGESTUroanalisis3Fecha').enable();
                                                                            Ext.getCmp('strGESTUroanalisis3Descripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTUroanalisis3Fecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Uroanalisis Descripcion',
                                                                id: 'strGESTUroanalisis3Descripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Uroanalisis Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTUroanalisis3Fecha'
                                                            }
                                                        ]
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'VDRL > 27 Sem',
                                                                fieldLabel: 'VDRL > 27 Sem',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTVDRL2',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTVDRL2Descripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTVDRL2Fecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTVDRL2Descripcion').disable();
                                                                            Ext.getCmp('fecGESTVDRL2Fecha').disable();
                                                                            Ext.getCmp('strGESTVDRL2Descripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTVDRL2Fecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTVDRL2Descripcion').enable();
                                                                            Ext.getCmp('fecGESTVDRL2Fecha').enable();
                                                                            Ext.getCmp('strGESTVDRL2Descripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTVDRL2Fecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'VDRL > 27 Sem Descripcion',
                                                                id: 'strGESTVDRL2Descripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'VDRL > 27 Sem Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTVDRL2Fecha'
                                                            }
                                                        ]
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Sifilis FTA',
                                                                fieldLabel: 'Sifilis FTA',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTSifilisFTA',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTSifilisFTADescripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTSifilisFTAFecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTSifilisFTADescripcion').disable();
                                                                            Ext.getCmp('fecGESTSifilisFTAFecha').disable();
                                                                            Ext.getCmp('strGESTSifilisFTADescripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTSifilisFTAFecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTSifilisFTADescripcion').enable();
                                                                            Ext.getCmp('fecGESTSifilisFTAFecha').enable();
                                                                            Ext.getCmp('strGESTSifilisFTADescripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTSifilisFTAFecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Sifilis FTA Descripcion',
                                                                id: 'strGESTSifilisFTADescripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Sifilis FTA Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTSifilisFTAFecha'
                                                            }
                                                        ]
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Gram',
                                                                fieldLabel: 'Gram',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTGram3',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTGram3Descripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTGram3Fecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTGram3Descripcion').disable();
                                                                            Ext.getCmp('fecGESTGram3Fecha').disable();
                                                                            Ext.getCmp('strGESTGram3Descripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTGram3Fecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTGram3Descripcion').enable();
                                                                            Ext.getCmp('fecGESTGram3Fecha').enable();
                                                                            Ext.getCmp('strGESTGram3Descripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTGram3Fecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Gram Descripcion',
                                                                id: 'strGESTGram3Descripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Gram Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTGram3Fecha'
                                                            }
                                                        ]
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Hemograma',
                                                                fieldLabel: 'Hemograma',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTCH3',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strGESTCH3Descripcion').allowBlank = true;
                                                                            Ext.getCmp('fecGESTCH3Fecha').allowBlank = true;
                                                                            Ext.getCmp('strGESTCH3Descripcion').disable();
                                                                            Ext.getCmp('fecGESTCH3Fecha').disable();
                                                                            Ext.getCmp('strGESTCH3Descripcion').clearInvalid();
                                                                            Ext.getCmp('fecGESTCH3Fecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strGESTCH3Descripcion').enable();
                                                                            Ext.getCmp('fecGESTCH3Fecha').enable();
                                                                            Ext.getCmp('strGESTCH3Descripcion').allowBlank = false;
                                                                            Ext.getCmp('fecGESTCH3Fecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Hemograma Descripcion',
                                                                id: 'strGESTCH3Descripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Hemograma Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecGESTCH3Fecha'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INFORMACION ADICIONAL',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Fuma',
                                                                width: 75,
                                                                fieldLabel : 'Fuma',
                                                                allowBlank: true,
                                                                store: stFuma,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTFuma',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue != "SI"){
                                                                            Ext.getCmp('intGESTCantFuma').allowBlank = true;
                                                                            Ext.getCmp('intGESTCantFuma').setValue(null);
                                                                            Ext.getCmp('intGESTCantFuma').disable();
                                                                            Ext.getCmp('intGESTCantFuma').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('intGESTCantFuma').enable();
                                                                            Ext.getCmp('intGESTCantFuma').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'Cant.:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                name: 'Cant',
                                                                minValue: 1,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                style: 'text-align:center;',
                                                                id: 'intGESTCantFuma'
                                                            },
                                                            {
                                                                html: 'Alcohol:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Alcohol',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTAlcohol'
                                                            },
                                                            {
                                                                html: 'Drogas:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Drogas',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTDrogas'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Hierro Indicado',
                                                                fieldLabel: 'Hierro Indicado',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTHierro'
                                                            },
                                                            {
                                                                html: 'Folatos Indicados:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Folatos Indicados',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTFolatos'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Antitetanica',
                                                                fieldLabel: 'Antitetanica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTAntitetanica'
                                                            },
                                                            {
                                                                html:'1ra Dosis AntiTetanica:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: '1ra Dosis AntiTetanica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGEST1DosisAntitetanica'
                                                            },
                                                            {
                                                                html:'2da Dosis AntiTetanica:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: '2da Dosis AntiTetanica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGEST2DosisAntitetanica'
                                                            },
                                                            {
                                                                html: 'AntiRubeola:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'AntiRubeola',
                                                                width: 120,
                                                                allowBlank: true,
                                                                store: stRubeola,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTRubeola'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'OTRAS PATOLOGIAS DURANTE EL ACTUAL EMBARAZO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'HTA Gestacional',
                                                                fieldLabel: 'HTA Gestacional',
                                                                value: 'false',
                                                                id: 'bolGESTHTAGestacional'
                                                            },
                                                            {
                                                                html: 'Preclampsia'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Preclampsia',
                                                                value: 'false',
                                                                id: 'bolGESTPreclampsia'
                                                            },
                                                            {
                                                                html: 'Infeccion Urinaria'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Infeccion Urinaria',
                                                                value: 'false',
                                                                id: 'bolGESTInfecUrina'
                                                            },
                                                            {
                                                                html: 'Amenaza Parto Pretermino'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Amenaza Parto Pretermino',
                                                                value: 'false',
                                                                id: 'bolGESTAmenazaPP'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'R.C.I.U.',
                                                                fieldLabel: 'R.C.I.U.',
                                                                value: 'false',
                                                                id: 'bolGESTRCIU'
                                                            },
                                                            {
                                                                html: 'Ruptura Prematura Membranas'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Ruptura Prematura Membranas',
                                                                value: 'false',
                                                                id: 'bolGESTRuptPremaMembr'
                                                            },
                                                            {
                                                                html: 'Anemia'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Anemia',
                                                                value: 'false',
                                                                id: 'bolGESTAnemia'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Otros',
                                                                fieldLabel : 'Otros',
                                                                width: 70,
                                                                allowBlank: true,
                                                                id: 'strGESTEnfOtros'
                                                            },
                                                            {
                                                                html: 'Hemorragia'
                                                            },
                                                            {
                                                                html: '1er Trimestre'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: '1er Trimestre',
                                                                width: 90,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTHemo1Sem'
                                                            },
                                                            {
                                                                html: '2do Trimestre'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: '2do Trimestre',
                                                                width: 90,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTHemo2Sem'
                                                            },
                                                            {
                                                                html: '3er Trimestre'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: '3er Trimestre',
                                                                width: 90,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strGESTHemo3Sem'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Tipo de Riesgo',
                                                        fieldLabel: 'Tipo de Riesgo',
                                                        width: 250,
                                                        allowBlank: true,
                                                        store: stRiesgoGestante,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strGESTRiesgo'
                                                    },
                                                    {
                                                        html: 'Fecha Probable de Parto'
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 120,
                                                        name: 'Fecha Probable de Parto',
                                                        allowBlank: true,
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        id: 'fecGESTParto'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EVOLUCION',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'EVOLUCION',
                                                        name: 'EVOLUCION',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEvolucion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INFORMACION PROXIMA CITA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                        {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha Probable Proxima Cita',
                                                                name: 'Fecha Probable Proxima Cita',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecPROXCITACita'
                                                            },
                                                            {
                                                                html: 'Profesional que Atiende'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Profesional que Atiende',
                                                                width: 250,
                                                                allowBlank: true,
                                                                store: stProfesionalAtiende,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPROXCITAProfesionalAtiende'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observacion',
                                                        name: 'Observacion',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memPROXCITAObservacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INCAPACIDAD',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Dias',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 50,
                                                                name: 'INCAPACIDAD DIAS',
                                                                minValue: 0,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'intDiasIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        //new Date(año,mes,dia) 01/05/2010
                                                                        if(Ext.getCmp('fecDesdeIncapacidad').getValue() == null || Ext.getCmp('fecDesdeIncapacidad').getValue() == ""){
                                                                            Ext.getCmp('fecDesdeIncapacidad').setValue(new Date().format('d/m/Y'))
                                                                        }
                                                                        var xFecha = Ext.getCmp('fecDesdeIncapacidad').getValue().format('d/m/Y')
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(pNew > 0)
                                                                            DiasIncapacidad = pNew - 1;
                                                                        else
                                                                            DiasIncapacidad = pNew;
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncDsd',
                                                                value: 'Desde:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD DESDE',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecDesdeIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(null);
                                                                        Ext.getCmp('fecHastaIncapacidad').setMinValue(pNew.format("d/m/Y"));
                                                                        Ext.getCmp('fecHastaIncapacidad').clearInvalid();
                                                                        var xFecha = pNew.format('d/m/Y')
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(Ext.getCmp('intDiasIncapacidad').getValue() > 0){
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue() - 1;
                                                                        }else{
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue();
                                                                        }
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncHst',
                                                                value: 'Hasta:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD HASTA',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecHastaIncapacidad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Observaciones',
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '100%',
                                                                width: 615,
                                                                name: 'INCAPACIDAD OBSERVACIONES',
                                                                height: 50,
                                                                allowBlank: true,
                                                                id: 'memIncapacidadObserva'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnImprimir',
                                                                text: 'Imprimir Incapacidad',
                                                                tooltip: 'Imprimir Incapacidad',
                                                                id: 'btnPrintIncapacidadHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                                                            window.open ("../../controlador/asistencial/printincapacidad0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() + "&pConsecutivo=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Incapacidad");
                                                                        else{
                                                                            Ext.Msg.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Usted No ha Guardado la Evolución',
                                                                                buttons: Ext.Msg.OK,
                                                                                icon: Ext.Msg.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            fsDiagnosticosConsulta
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    //Predefinir Comportamiento Campos

                    if(Ext.getCmp('sysFechaHC').getValue() != null || Ext.getCmp('sysFechaHC').getValue() != 0){
                       calculoEdadPacienteMeses()
                    }
                    
                    Ext.getCmp('sysFinalidadConsultaHC').setValue(06);
                    
                    //COMPANANTE MENOR A 14 ANOS
                    
                    if(MesesCumplidos <= 179){
                        Ext.getCmp('strDATINGPROGAcompanante').allowBlank = false;
                        Ext.getCmp('strDATINGPROGParentesco').allowBlank = false;
                    }else{
                        Ext.getCmp('strDATINGPROGAcompanante').allowBlank = true;
                        Ext.getCmp('strDATINGPROGParentesco').allowBlank = true;
                    }
                    
                    Ext.getCmp('fsExamenesPrimerTrimestre').setVisible(false);
                    Ext.getCmp('fsExamenesSegundoTrimestre').setVisible(false);
                    Ext.getCmp('fsExamenesTercerTrimestre').setVisible(false);
                    //CARGAR ANTECEDENTES
                    if(paramOpcion === "Nuevo"){ 
                        Ext.Ajax.request({
                            url: '../../controlador/asistencial/evolucionhc.php',
                            waitMsg: 'Cargando Información...',
                            params:{
                                pCAS: myCAS,
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                task: 'ImportarAntecedentesFamiliares'
                            },
                            success: function(result, request)
                            {
                                var jsonAntFamiliares = Ext.util.JSON.decode(result.responseText);
                                CargarDataHCAntecedentes(jsonAntFamiliares.data.sysEvolucion);
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            },
                            scope:this
                        });
                    }
                }
            }
        });
        winHCGestante001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;
    AniosCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    AniosCumplidos = MostrarEdadAnios(valFecha1, valFecha2);
}