/*
* @category    Panel Alteraciones Joven
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnAlteracionesJovenUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnAlteracionesJoven',
    initComponent: function() {
        this.items = [
            {
                xtype: 'panel',
                anchor: '100%',
                autoHeight: true,
                layout: 'form',
                labelWidth: 260,
                padding: 5,
                items: [
                    {
                        xtype: 'combo',
                        labelStyle: 'background-color:#FF0; color:#F00; text-decoration:blink;',
                        fieldLabel: 'Registrar HC Alteraciones del Joven?',
                        name: 'Registrar HC Alteraciones del Joven?',
                        width: 60,
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strRegistrarAlteracionesJoven',
                        listeners:{
                            change : function( t, newValue, oldValue){
                                if(newValue == "NO"){
                                    Ext.getCmp('fsAlteracionesJoven').setVisible(false);
                                    Ext.getCmp('fecALTJOVCita').allowBlank = true;
                                    Ext.getCmp('strALTJOVProfesionalAtiende').allowBlank = true;
                                    Ext.getCmp('strALTJOVDependencia').allowBlank = true;
                                    Ext.getCmp('strALTJOVRelIntrafamiliares').allowBlank = true;
                                    Ext.getCmp('strALTJOVRelInterpersonales').allowBlank = true;
                                    Ext.getCmp('strALTJOVComIntrafamiliar').allowBlank = true;
                                    Ext.getCmp('memALTJOVproyectoVida').allowBlank = true;
                                    Ext.getCmp('bolALTJOVFumador').allowBlank = true;
                                    Ext.getCmp('bolALTJOVAlcohol').allowBlank = true;
                                    Ext.getCmp('bolALTJOVSustPsicoa').allowBlank = true;
                                    Ext.getCmp('bolALTJOVDietaSaludable').allowBlank = true;
                                    Ext.getCmp('bolALTJOVActFisica').allowBlank = true;
                                    Ext.getCmp('bolALTJOVManejoStress').allowBlank = true;
                                    Ext.getCmp('memALTJOVPlan').allowBlank = true;
                                    Ext.getCmp('sysALTJOVDiag').allowBlank = true;
                                    Ext.getCmp('intALTJOVHemoglo').allowBlank = true;
                                    Ext.getCmp('strALTJOVVidaSexual').allowBlank = true;
                                    Ext.getCmp('fecALTJOVCita').setValue(null);
                                    Ext.getCmp('strALTJOVProfesionalAtiende').setValue(null);
                                    Ext.getCmp('strALTJOVVidaSexual').setValue(null);
                                    Ext.getCmp('intALTJOVHemoglo').setValue(null);
                                    Ext.getCmp('sysALTJOVDiag').setValue(null);
                                    Ext.getCmp('strALTJOVDependencia').setValue(null);
                                    Ext.getCmp('strALTJOVRelIntrafamiliares').setValue(null);
                                    Ext.getCmp('strALTJOVRelInterpersonales').setValue(null);
                                    Ext.getCmp('strALTJOVComIntrafamiliar').setValue(null);
                                    Ext.getCmp('memALTJOVproyectoVida').setValue(null);
                                    Ext.getCmp('bolALTJOVFumador').setValue(null);
                                    Ext.getCmp('bolALTJOVAlcohol').setValue(null);
                                    Ext.getCmp('bolALTJOVSustPsicoa').setValue(null);
                                    Ext.getCmp('bolALTJOVDietaSaludable').setValue(null);
                                    Ext.getCmp('bolALTJOVActFisica').setValue(null);
                                    Ext.getCmp('bolALTJOVManejoStress').setValue(null);
                                    Ext.getCmp('memALTJOVPlan').setValue(null);
                                    Ext.getCmp('fecALTJOVCita').disable();
                                    Ext.getCmp('strALTJOVProfesionalAtiende').disable();
                                    Ext.getCmp('strALTJOVDependencia').disable();
                                    Ext.getCmp('strALTJOVRelIntrafamiliares').disable();
                                    Ext.getCmp('strALTJOVRelInterpersonales').disable();
                                    Ext.getCmp('strALTJOVComIntrafamiliar').disable();
                                    Ext.getCmp('memALTJOVproyectoVida').disable();
                                    Ext.getCmp('bolALTJOVFumador').disable();
                                    Ext.getCmp('bolALTJOVAlcohol').disable();
                                    Ext.getCmp('bolALTJOVSustPsicoa').disable();
                                    Ext.getCmp('bolALTJOVDietaSaludable').disable();
                                    Ext.getCmp('bolALTJOVActFisica').disable();
                                    Ext.getCmp('bolALTJOVManejoStress').disable();
                                    Ext.getCmp('memALTJOVPlan').disable();
                                    Ext.getCmp('sysALTJOVDiag').disable();
                                    Ext.getCmp('intALTJOVHemoglo').disable();
                                    Ext.getCmp('strALTJOVVidaSexual').disable();
                                    Ext.getCmp('fecALTJOVCita').clearInvalid();
                                    Ext.getCmp('strALTJOVProfesionalAtiende').clearInvalid();
                                    Ext.getCmp('strALTJOVVidaSexual').clearInvalid();
                                    Ext.getCmp('intALTJOVHemoglo').clearInvalid();
                                    Ext.getCmp('sysALTJOVDiag').clearInvalid();
                                    Ext.getCmp('strALTJOVDependencia').clearInvalid();
                                    Ext.getCmp('strALTJOVRelIntrafamiliares').clearInvalid();
                                    Ext.getCmp('strALTJOVRelInterpersonales').clearInvalid();
                                    Ext.getCmp('strALTJOVComIntrafamiliar').clearInvalid();
                                    Ext.getCmp('memALTJOVproyectoVida').clearInvalid();
                                    Ext.getCmp('bolALTJOVFumador').clearInvalid();
                                    Ext.getCmp('bolALTJOVAlcohol').clearInvalid();
                                    Ext.getCmp('bolALTJOVSustPsicoa').clearInvalid();
                                    Ext.getCmp('bolALTJOVDietaSaludable').clearInvalid();
                                    Ext.getCmp('bolALTJOVActFisica').clearInvalid();
                                    Ext.getCmp('bolALTJOVManejoStress').clearInvalid();
                                    Ext.getCmp('memALTJOVPlan').clearInvalid();
                                }else{
                                    Ext.getCmp('fsAlteracionesJoven').setVisible(true);
                                    Ext.getCmp('fecALTJOVCita').allowBlank =false;
                                    Ext.getCmp('strALTJOVProfesionalAtiende').allowBlank =false;
                                    Ext.getCmp('strALTJOVDependencia').allowBlank =false;
                                    Ext.getCmp('strALTJOVRelIntrafamiliares').allowBlank =false;
                                    Ext.getCmp('strALTJOVRelInterpersonales').allowBlank =false;
                                    Ext.getCmp('strALTJOVComIntrafamiliar').allowBlank =false;
                                    Ext.getCmp('memALTJOVproyectoVida').allowBlank =false;
                                    Ext.getCmp('bolALTJOVFumador').allowBlank =false;
                                    Ext.getCmp('bolALTJOVAlcohol').allowBlank =false;
                                    Ext.getCmp('bolALTJOVSustPsicoa').allowBlank =false;
                                    Ext.getCmp('bolALTJOVDietaSaludable').allowBlank =false;
                                    Ext.getCmp('bolALTJOVActFisica').allowBlank =false;
                                    Ext.getCmp('bolALTJOVManejoStress').allowBlank =false;
                                    Ext.getCmp('memALTJOVPlan').allowBlank =false;
                                    Ext.getCmp('sysALTJOVDiag').allowBlank =false;
                                    Ext.getCmp('intALTJOVHemoglo').allowBlank =false;
                                    Ext.getCmp('strALTJOVVidaSexual').allowBlank =false;
                                    Ext.getCmp('fecALTJOVCita').enable();
                                    Ext.getCmp('strALTJOVProfesionalAtiende').enable();
                                    Ext.getCmp('strALTJOVVidaSexual').enable();
                                    Ext.getCmp('intALTJOVHemoglo').enable();
                                    Ext.getCmp('sysALTJOVDiag').enable();
                                    Ext.getCmp('strALTJOVDependencia').enable();
                                    Ext.getCmp('strALTJOVRelIntrafamiliares').enable();
                                    Ext.getCmp('strALTJOVRelInterpersonales').enable();
                                    Ext.getCmp('strALTJOVComIntrafamiliar').enable();
                                    Ext.getCmp('memALTJOVproyectoVida').enable();
                                    Ext.getCmp('bolALTJOVFumador').enable();
                                    Ext.getCmp('bolALTJOVAlcohol').enable();
                                    Ext.getCmp('bolALTJOVSustPsicoa').enable();
                                    Ext.getCmp('bolALTJOVDietaSaludable').enable();
                                    Ext.getCmp('bolALTJOVActFisica').enable();
                                    Ext.getCmp('bolALTJOVManejoStress').enable();
                                    Ext.getCmp('memALTJOVPlan').enable();
                                }
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'PROGRAMA: ALTERACIONES DEL JOVEN',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 5,
                id: 'fsAlteracionesJoven',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'Dependencia Economica',
                                fieldLabel: 'Dependencia Economica',
                                width: 100,
                                allowBlank: true,
                                store: stDependenciaEconomica,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strALTJOVDependencia'
                            },
                            {
                                html: 'Rel Intrafamiliares'
                            },
                            {
                                xtype: 'combo',
                                name: 'Relaciones Intrafamiliares',
                                width: 100,
                                allowBlank: true,
                                store: stRelaciones,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strALTJOVRelIntrafamiliares'
                            },
                            {
                                html: 'Rel Interpersonales'
                            },
                            {
                                xtype: 'combo',
                                name: 'Relaciones Interpersonales',
                                width: 100,
                                allowBlank: true,
                                store: stRelaciones,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strALTJOVRelInterpersonales'
                            },
                            {
                                html: 'Com Intrafamiliar'
                            },
                            {
                                xtype: 'combo',
                                name: 'Comunicacion Intrafamiliar',
                                width: 100,
                                allowBlank: true,
                                store: stRelaciones,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strALTJOVComIntrafamiliar'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        fieldLabel: 'Vida Sexual',
                        name: 'Riesgo Total',
                        width: 250,
                        readOnly: true,
                        id: 'strALTJOVVidaSexual'
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'Proyecto de Vida',
                        name: 'Proyecto de Vida',
                        height: 100,
                        allowBlank: true,
                        id: 'memALTJOVproyectoVida',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('memALTJOVproyectoVida').setValue("No Refiere");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Factores de Riesgo',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'checkbox',
                                        fieldLabel: 'Fumador',
                                        name: 'Fumador',
                                        value: 'false',
                                        id: 'bolALTJOVFumador'
                                    },
                                    {
                                        html: 'Alcohol:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Alcohol',
                                        value: 'false',
                                        id: 'bolALTJOVAlcohol'
                                    },
                                    {
                                        html: 'Sust. Psicoa.:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Sust. Psicoa.',
                                        value: 'false',
                                        id: 'bolALTJOVSustPsicoa'
                                    },
                                    {
                                        html: 'Dieta Saludable:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Dieta Saludable',
                                        value: 'false',
                                        id: 'bolALTJOVDietaSaludable'
                                    },
                                    {
                                        html: 'Act. Fisica:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Act. Fisica',
                                        value: 'false',
                                        id: 'bolALTJOVActFisica'
                                    },
                                    {
                                        html: 'Manejo Stress:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Manejo Stress',
                                        value: 'false',
                                        id: 'bolALTJOVManejoStress'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'numberfield',
                        fieldLabel: 'Hemoglobina',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 2,
                        name: 'Hemoglobina',
                        allowBlank: true,
                        id: 'intALTJOVHemoglo'
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'PLAN',
                        name: 'PLAN',
                        height: 100,
                        allowBlank: true,
                        id: 'memALTJOVPlan'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                                {
                                xtype: 'textfield',
                                width: 96,
                                allowBlank: true,
                                fieldLabel: 'Diagnostico',
                                id: 'sysALTJOVDiag',
                                listeners:{
                                    specialkey: function(f,e){
                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                        {
                                            if (f.getValue() != "" && f.getValue() != null){
                                                Ext.Ajax.request({
                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                    params:{
                                                        task: 'BUSCAR',
                                                        pCodigo: f.getValue().toUpperCase()
                                                    },
                                                    success: function(response,options)
                                                    {
                                                        var el = Ext.get('response'); // get the LOG
                                                        var Respuesta = response.responseText;
                                                        var Contenido = Respuesta.split('^');
                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                            Ext.getCmp('sysALTJOVDiag').setValue(null);
                                                            Ext.getCmp('sysALTJOVDiagNom').setValue(null);
                                                        } else {
                                                            Ext.getCmp('sysALTJOVDiag').setValue(Contenido[0]);
                                                            Ext.getCmp('sysALTJOVDiagNom').setValue(Contenido[1]);
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        var el = Ext.get('response');
                                                        Ext.getCmp('sysALTJOVDiag').setValue(null);
                                                        Ext.getCmp('sysALTJOVDiagNom').setValue(null);
                                                    },
                                                    scope:this //bind the callbacks
                                                });
                                            }else{
                                                Ext.getCmp('sysALTJOVDiag').setValue(null);
                                                Ext.getCmp('sysALTJOVDiagNom').setValue(null);
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'textarea',
                                readOnly: true,
                                width: 625,
                                height: 22,
                                id: 'sysALTJOVDiagNom'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Diagnostico Principal',
                                listeners:{
                                    click : function(){
                                        buscarcie10('sysALTJOVDiag','sysALTJOVDiagNom');
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'datefield',
                        width: 120,
                        fieldLabel: 'Fecha Probable Proxima Cita',
                        name: 'Fecha Probable Proxima Cita',
                        allowBlank: true,
                        emptyText: '(dia/mes/año) ',
                        style: 'text-align:center;',
                        id: 'fecALTJOVCita'
                    },
                    {
                        html: 'Profesional que Atiende'
                    },
                    {
                        xtype: 'combo',
                        name: 'Profesional que Atiende',
                        width: 250,
                        allowBlank: true,
                        store: stProfesionalAtiende,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strALTJOVProfesionalAtiende'
                    }
                ]
            }
        ];
        pnAlteracionesJovenUi.superclass.initComponent.call(this);
    }
});
