/*
* @category    Panel Programas Especiales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnProgramasEspecialesUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnProgramasEspeciales',
    initComponent: function() {
        this.items = [
            {
                xtype: 'fieldset',
                title: 'INFORMACION PROGRAMAS ESPECIALES (HTA - DM - NEFROPROTECCION)',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 5,
                id: 'fsProgramasEspeciales',
                items: [
                    {
                        xtype: 'fieldset',
                        title: 'Datos Generales Programa',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        labelSeparator: '',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'panel',
                                anchor: '100%',
                                autoHeight: true,
                                labelWidth: 290,
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Esta Atencion corresponde a ingreso al programa?',
                                        name: 'Esta Atencion corresponde a ingreso al programa?',
                                        width: 90,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEIngreso',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue !== "" && newValue !== null){
                                                    var txt = "";
                                                    if(newValue === "SI"){
                                                        txt = "INGRESO AL PROGRAMA";
                                                    }else{
                                                        txt = "CONTROL";
                                                    }
                                                    Ext.Msg.show({
                                                        title: 'eOfiClinic',
                                                        msg: 'Esta Seguro que la atencion es de: ' + txt + '?',
                                                        buttons: Ext.Msg.YESNO,
                                                        icon: Ext.Msg.QUESTION,
                                                        fn: function(btn){
                                                            if(btn === "yes"){
                                                                Ext.getCmp('sysYaOrdenamientosHC').setValue(0);
                                                                if(newValue === "SI"){
                                                                    Ext.getCmp('fecPROGESPEIngreso').allowBlank = false;
                                                                    Ext.getCmp('fecPROGESPEUltimoControl').allowBlank = true;
                                                                    Ext.getCmp('intPROGESPEControlNumero').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPEViaCaptacion').allowBlank = false;
                                                                    Ext.getCmp('strProgramaCronicos').allowBlank = false;
                                                                    Ext.getCmp('strMetodoPlanifica').allowBlank = false;
                                                                    Ext.getCmp('intRiesgoCardioVascular').allowBlank = false;
                                                                    Ext.getCmp('strClasificacionRiesgoCardioVascular').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPEDxHTA').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPEDxDM').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPEDxNefroProteccion').allowBlank = false;
                                                                    Ext.getCmp('intTASistolicaIngreso').allowBlank = false;
                                                                    Ext.getCmp('intTADiastolicaIngreso').allowBlank = false;
                                                                    Ext.getCmp('intTallaIngreso').allowBlank = false;
                                                                    Ext.getCmp('intPesoIngreso').allowBlank = false;
                                                                    Ext.getCmp('intIMCIngreso').allowBlank = false;
                                                                    Ext.getCmp('strPAIngreso').allowBlank = false;
                                                                    Ext.getCmp('fecPROGESPEParcialorina').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPEParcialorinaRes').allowBlank = false;
                                                                    Ext.getCmp('fecPROGESPEColesterolTotal').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPEColesterolTotalRes').allowBlank = false;
                                                                    Ext.getCmp('fecPROGESPEColesterolHDL').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPEColesterolHDLRes').allowBlank = false;
                                                                    Ext.getCmp('fecPROGESPEColesterolLDL').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPEColesterolLDLRes').allowBlank = false;
                                                                    Ext.getCmp('fecPROGESPETrigliceridos').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPETrigliceridosRes').allowBlank = false;
                                                                    Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').allowBlank = false;
                                                                    Ext.getCmp('fecPROGESPEGlicemia').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPEGlicemiaRes').allowBlank = false;
                                                                    Ext.getCmp('fecPROGESPEMicroAlbuminuria').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').allowBlank = false;
                                                                    Ext.getCmp('fecPROGESPEProteinas').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPEProteinasRes').allowBlank = false;
                                                                    Ext.getCmp('fecPROGESPEEcografiaRenal').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPEEcografiaRenalRes').allowBlank = false;
                                                                    Ext.getCmp('fecPROGESPECreatinina').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPECreatininaRes').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeParcialorina').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolTotal').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolHDL').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolLDL').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeTrigliceridos').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeHemoglobinaGlicosilada').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeGlicemia').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeMicroAlbuminuria').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeCreatinina').allowBlank = true;
                                                                }else{
                                                                    Ext.getCmp('fecPROGESPEIngreso').allowBlank = true;
                                                                    Ext.getCmp('fecPROGESPEUltimoControl').allowBlank = true;
                                                                    Ext.getCmp('intPROGESPEControlNumero').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPEViaCaptacion').allowBlank = true;
                                                                    Ext.getCmp('strProgramaCronicos').allowBlank = true;
                                                                    Ext.getCmp('strMetodoPlanifica').allowBlank = true;
                                                                    Ext.getCmp('intRiesgoCardioVascular').allowBlank = true;
                                                                    Ext.getCmp('strClasificacionRiesgoCardioVascular').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPEDxHTA').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPEDxDM').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPEDxNefroProteccion').allowBlank = true;
                                                                    Ext.getCmp('intTASistolicaIngreso').allowBlank = true;
                                                                    Ext.getCmp('intTADiastolicaIngreso').allowBlank = true;
                                                                    Ext.getCmp('intTallaIngreso').allowBlank = true;
                                                                    Ext.getCmp('intPesoIngreso').allowBlank = true;
                                                                    Ext.getCmp('intIMCIngreso').allowBlank = true;
                                                                    Ext.getCmp('strPAIngreso').allowBlank = true;
                                                                    Ext.getCmp('fecPROGESPEParcialorina').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPEParcialorinaRes').allowBlank = true;
                                                                    Ext.getCmp('fecPROGESPEColesterolTotal').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPEColesterolTotalRes').allowBlank = true;
                                                                    Ext.getCmp('fecPROGESPEColesterolHDL').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPEColesterolHDLRes').allowBlank = true;
                                                                    Ext.getCmp('fecPROGESPEColesterolLDL').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPEColesterolLDLRes').allowBlank = true;
                                                                    Ext.getCmp('fecPROGESPETrigliceridos').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPETrigliceridosRes').allowBlank = true;
                                                                    Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').allowBlank = true;
                                                                    Ext.getCmp('fecPROGESPEGlicemia').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPEGlicemiaRes').allowBlank = true;
                                                                    Ext.getCmp('fecPROGESPEMicroAlbuminuria').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').allowBlank = true;
                                                                    Ext.getCmp('fecPROGESPEProteinas').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPEProteinasRes').allowBlank = true;
                                                                    Ext.getCmp('fecPROGESPEEcografiaRenal').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPEEcografiaRenalRes').allowBlank = true;
                                                                    Ext.getCmp('fecPROGESPECreatinina').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPECreatininaRes').allowBlank = true;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeParcialorina').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolTotal').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolHDL').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolLDL').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeTrigliceridos').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeHemoglobinaGlicosilada').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeGlicemia').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeMicroAlbuminuria').allowBlank = false;
                                                                    Ext.getCmp('strPROGESPESeguimientoTraeCreatinina').allowBlank = false;
                                                                }
                                                            }
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        fieldLabel: 'Fecha Ingreso',
                                        name: 'Fecha Ingreso',
                                        allowBlank: false,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEIngreso'
                                    },
                                    {
                                        html: 'Ultimo Control'
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Fecha Ultimo Control',
                                        emptyText: '(dia/mes/año)',
                                        readOnly: true,
                                        width: 120,
                                        allowBlank: true,
                                        id: 'fecPROGESPEUltimoControl'
                                    },
                                    {
                                        html: 'Control Numero'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 40,
                                        name: 'Control Numero',
                                        minValue: 0,
                                        readOnly: true,
                                        vaue: 0,
                                        allowBlank: true,
                                        style: 'text-align:center;',
                                        id: 'intPROGESPEControlNumero'
                                    },
                                    {
                                        html: 'Via de Captacion:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Via de Captacion',
                                        width: 150,
                                        allowBlank: false,
                                        store: stViaCaptacion,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEViaCaptacion'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Programa Actual',
                                name: 'Programa Actual',
                                anchor: '100%',
                                allowBlank: false,
                                store: stProgramaCronicos,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strProgramaCronicos'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Metodo Planificacion',
                                name: 'Metodo Planificacion',
                                anchor: '100%',
                                allowBlank: true,
                                store: 'StoreMetodosPlanificacion',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strMetodoPlanifica'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        width: 70,
                                        fieldLabel: 'Riesgo Cardio Vascular',
                                        name: '% Riesgo Cardio Vascular',
                                        emptyText: '%',
                                        minValue: 100,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        style: 'text-align:center;',
                                        id: 'intRiesgoCardioVascular'
                                    },
                                    {
                                        html: 'Clasificacion'
                                    },
                                    
                                    {
                                        xtype: 'combo',
                                        name: 'Clasificacion Riesgo Cardio Vascular',
                                        width: 250,
                                        allowBlank: true,
                                        store: stDatProgNivelRiesgo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strClasificacionRiesgoCardioVascular'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Datos Ingreso Programa',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        labelSeparator: '',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Dx HTA',
                                        name: 'Dx HTA',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEDxHTA',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strPROGESPETipoDxHTA').allowBlank = true;
                                                    Ext.getCmp('intPROGESPEDxHTAMes').allowBlank = true;
                                                    Ext.getCmp('intPROGESPEDxHTAAno').allowBlank = true;
                                                    Ext.getCmp('strPROGESPENivelRiesgoHTA').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEDxHTAEstadio').allowBlank = true;
                                                    Ext.getCmp('strPROGESPETipoDxHTA').setValue(null);
                                                    Ext.getCmp('intPROGESPEDxHTAMes').setValue(null);
                                                    Ext.getCmp('intPROGESPEDxHTAAno').setValue(null);
                                                    Ext.getCmp('strPROGESPENivelRiesgoHTA').setValue(null);
                                                    Ext.getCmp('strPROGESPEDxHTAEstadio').setValue(null);
                                                    Ext.getCmp('strPROGESPETipoDxHTA').disable();
                                                    Ext.getCmp('intPROGESPEDxHTAMes').disable();
                                                    Ext.getCmp('intPROGESPEDxHTAAno').disable();
                                                    Ext.getCmp('strPROGESPEDxHTAEstadio').disable();
                                                    Ext.getCmp('strPROGESPENivelRiesgoHTA').disable();
                                                    Ext.getCmp('strPROGESPETipoDxHTA').clearInvalid();
                                                    Ext.getCmp('intPROGESPEDxHTAMes').clearInvalid();
                                                    Ext.getCmp('strPROGESPEDxHTAEstadio').clearInvalid();
                                                    Ext.getCmp('intPROGESPEDxHTAAno').clearInvalid();
                                                    Ext.getCmp('strPROGESPENivelRiesgoHTA').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strPROGESPETipoDxHTA').enable();
                                                    Ext.getCmp('intPROGESPEDxHTAMes').enable();
                                                    Ext.getCmp('intPROGESPEDxHTAAno').enable();
                                                    Ext.getCmp('strPROGESPENivelRiesgoHTA').enable();
                                                    Ext.getCmp('strPROGESPEDxHTAEstadio').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEDxHTAEstadio').enable();
                                                    Ext.getCmp('strPROGESPETipoDxHTA').allowBlank = false;
                                                    Ext.getCmp('intPROGESPEDxHTAMes').allowBlank = false;
                                                    Ext.getCmp('intPROGESPEDxHTAAno').allowBlank = false;
                                                    Ext.getCmp('strPROGESPENivelRiesgoHTA').allowBlank = false;
                                                    calculoEstadioHTA()
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Tipo de Dx:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Tipo de Dx',
                                        width: 70,
                                        allowBlank: false,
                                        store: stDatProgTipoDx,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETipoDxHTA'
                                    },
                                    {
                                        html:'Nivel de Riesgo:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Nivel de Riesgo',
                                        width: 70,
                                        allowBlank: false,
                                        store: stDatProgNivelRiesgo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPENivelRiesgoHTA'
                                    },
                                    {
                                        html:'Fecha Dx:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Mes',
                                        emptyText: 'Mes',
                                        width: 50,
                                        minValue: 1,
                                        maxValue: 12,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        id: 'intPROGESPEDxHTAMes'
                                    },
                                    {
                                        html:'/'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Año',
                                        emptyText: 'Año',
                                        width: 50,
                                        minValue: 1900,
                                        maxValue: 2199,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        id: 'intPROGESPEDxHTAAno'
                                    },
                                    {
                                        html:'Estadio:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Estadio',
                                        width: 100,
                                        emptyText: 'Resultado',
                                        readOnly: true,
                                        allowBlank: true,
                                        id: 'strPROGESPEDxHTAEstadio'
                                    }
                                ]
                            },
                            {
                                html: '<br>'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Dx DM',
                                        name: 'Dx DM',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEDxDM',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strPROGESPETipoDxDM').allowBlank = true;
                                                    Ext.getCmp('strPROGESPENivelRiesgoDM').allowBlank = true;
                                                    Ext.getCmp('intPROGESPEDxDMMes').allowBlank = true;
                                                    Ext.getCmp('intPROGESPEDxDMAno').allowBlank = true;
                                                    Ext.getCmp('strPROGESPETipoDM').allowBlank = true;
                                                    Ext.getCmp('strPROGESPETipoDMInsulina').allowBlank = true;
                                                    Ext.getCmp('strPROGESPETipoDxDM').setValue(null);
                                                    Ext.getCmp('strPROGESPENivelRiesgoDM').setValue(null);
                                                    Ext.getCmp('intPROGESPEDxDMMes').setValue(null);
                                                    Ext.getCmp('intPROGESPEDxDMAno').setValue(null);
                                                    Ext.getCmp('strPROGESPETipoDM').setValue(null);
                                                    Ext.getCmp('strPROGESPETipoDMInsulina').setValue(null);
                                                    Ext.getCmp('strPROGESPETipoDxDM').disable();
                                                    Ext.getCmp('strPROGESPENivelRiesgoDM').disable();
                                                    Ext.getCmp('intPROGESPEDxDMMes').disable();
                                                    Ext.getCmp('intPROGESPEDxDMAno').disable();
                                                    Ext.getCmp('strPROGESPETipoDM').disable();
                                                    Ext.getCmp('strPROGESPETipoDMInsulina').disable();
                                                    Ext.getCmp('strPROGESPETipoDxDM').clearInvalid();
                                                    Ext.getCmp('strPROGESPENivelRiesgoDM').clearInvalid();
                                                    Ext.getCmp('intPROGESPEDxDMMes').clearInvalid();
                                                    Ext.getCmp('intPROGESPEDxDMAno').clearInvalid();
                                                    Ext.getCmp('strPROGESPETipoDM').clearInvalid();
                                                    Ext.getCmp('strPROGESPETipoDMInsulina').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strPROGESPETipoDxDM').enable();
                                                    Ext.getCmp('strPROGESPENivelRiesgoDM').enable();
                                                    Ext.getCmp('intPROGESPEDxDMMes').enable();
                                                    Ext.getCmp('intPROGESPEDxDMAno').enable();
                                                    Ext.getCmp('strPROGESPETipoDM').enable();
                                                    Ext.getCmp('strPROGESPETipoDMInsulina').enable();
                                                    Ext.getCmp('strPROGESPETipoDxDM').allowBlank = false;
                                                    Ext.getCmp('strPROGESPENivelRiesgoDM').allowBlank = false;
                                                    Ext.getCmp('intPROGESPEDxDMMes').allowBlank = false;
                                                    Ext.getCmp('intPROGESPEDxDMAno').allowBlank = false;
                                                    Ext.getCmp('strPROGESPETipoDM').allowBlank = false;
                                                    Ext.getCmp('strPROGESPETipoDMInsulina').allowBlank = false;

                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Tipo de Dx:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Tipo de Dx',
                                        width: 70,
                                        allowBlank: false,
                                        store: stDatProgTipoDx,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETipoDxDM'
                                    },
                                    {
                                        html:'Nivel de Riesgo:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Nivel de Riesgo',
                                        width: 70,
                                        allowBlank: false,
                                        store: stDatProgNivelRiesgo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPENivelRiesgoDM'
                                    },
                                    {
                                        html:'Fecha Dx:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Mes',
                                        emptyText: 'Mes',
                                        width: 50,
                                        minValue: 1,
                                        maxValue: 12,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        id: 'intPROGESPEDxDMMes'
                                    },
                                    {
                                        html:'/'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Año',
                                        emptyText: 'Año',
                                        width: 50,
                                        minValue: 1900,
                                        maxValue: 2199,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        id: 'intPROGESPEDxDMAno'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        html:'Tipo DM:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Tipo de DM',
                                        width: 150,
                                        allowBlank: false,
                                        store: stDatProgTipoDM,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETipoDM'
                                    },
                                    {
                                        html:'Tipo Insulina:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Tipo Insulina',
                                        width: 150,
                                        allowBlank: false,
                                        store: stDatProgTipoInsulina,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETipoDMInsulina'
                                    }
                                ]
                            },
                            {
                                html: '<br>'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Dx Nefroprot',
                                        name: 'Dx Nefroproteccion',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEDxNefroProteccion',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strPROGESPETipoDxNefroProteccion').allowBlank = true;
                                                    Ext.getCmp('intPROGESPEDxNefroProteccionMes').allowBlank = true;
                                                    Ext.getCmp('intPROGESPEDxNefroProteccionAno').allowBlank = true;
                                                    Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEEstadioNefroProteccion').allowBlank = true;
                                                    Ext.getCmp('strPROGESPETipoDxNefroProteccion').setValue(null);
                                                    Ext.getCmp('intPROGESPEDxNefroProteccionMes').setValue(null);
                                                    Ext.getCmp('intPROGESPEDxNefroProteccionAno').setValue(null);
                                                    Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').setValue(null);
                                                    Ext.getCmp('strPROGESPEEstadioNefroProteccion').setValue(null);
                                                    Ext.getCmp('strPROGESPETipoDxNefroProteccion').disable();
                                                    Ext.getCmp('intPROGESPEDxNefroProteccionMes').disable();
                                                    Ext.getCmp('intPROGESPEDxNefroProteccionAno').disable();
                                                    Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').disable();
                                                    Ext.getCmp('strPROGESPEEstadioNefroProteccion').disable();
                                                    Ext.getCmp('strPROGESPETipoDxNefroProteccion').clearInvalid();
                                                    Ext.getCmp('intPROGESPEDxNefroProteccionMes').clearInvalid();
                                                    Ext.getCmp('intPROGESPEDxNefroProteccionAno').clearInvalid();
                                                    Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').clearInvalid();
                                                    Ext.getCmp('strPROGESPEEstadioNefroProteccion').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strPROGESPETipoDxNefroProteccion').enable();
                                                    Ext.getCmp('intPROGESPEDxNefroProteccionMes').enable();
                                                    Ext.getCmp('intPROGESPEDxNefroProteccionAno').enable();
                                                    Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').enable();
                                                    Ext.getCmp('strPROGESPEEstadioNefroProteccion').enable();
                                                    Ext.getCmp('strPROGESPETipoDxNefroProteccion').allowBlank = false;
                                                    Ext.getCmp('intPROGESPEDxNefroProteccionMes').allowBlank = false;
                                                    Ext.getCmp('intPROGESPEDxNefroProteccionAno').allowBlank = false;
                                                    Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEEstadioNefroProteccion').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Tipo de Dx:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Tipo de Dx',
                                        width: 70,
                                        allowBlank: false,
                                        store: stDatProgTipoDx,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETipoDxNefroProteccion'
                                    },
                                     {
                                        html:'Nivel de Riesgo:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Nivel de Riesgo',
                                        width: 70,
                                        allowBlank: false,
                                        store: stDatProgNivelRiesgo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPENivelRiesgoNefroProteccion'
                                    },
                                    {
                                        html:'Fecha Dx:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Mes',
                                        emptyText: 'Mes',
                                        width: 50,
                                        minValue: 1,
                                        maxValue: 12,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        id: 'intPROGESPEDxNefroProteccionMes'
                                    },
                                    {
                                        html:'/'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Año',
                                        emptyText: 'Año',
                                        width: 50,
                                        minValue: 1900,
                                        maxValue: 2199,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        id: 'intPROGESPEDxNefroProteccionAno'
                                    },
                                    {
                                        html:'Estadio:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Estadio',
                                        width: 100,
                                        allowBlank: false,
                                        store: stDatProgEstadioNefroProteccion,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEEstadioNefroProteccion'
                                    }
                                ]
                            },
                            {
                                html: '<br><hr><br>'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        fieldLabel: 'T.A.',
                                        name: 'T.A. Sistolica Ingreso',
                                        width: 70,
                                        minValue: 0,
                                        maxValue: 300,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        emptyText: 'Sistolica',
                                        id: 'intTASistolicaIngreso'
                                    },
                                    {
                                        html: '/'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'T.A. Diastolica Ingreso',
                                        width: 70,
                                        minValue: 0,
                                        maxValue: 300,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        emptyText: 'Diastolica',
                                        id: 'intTADiastolicaIngreso'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        width: 60,
                                        minValue: 0,
                                        maxValue: 250,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        fieldLabel: 'TALLA (cm)',
                                        name:"TALLA (cm)",
                                        emptyText: '(cm)',
                                        id: 'intTallaIngreso',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                if(pNew == null || pNew == 0){
                                                    Ext.getCmp('intTallaIngreso').setValue(null);
                                                    Ext.getCmp('intIMCIngreso').setValue(0);
                                                }else{
                                                    if(Ext.getCmp('intPesoIngreso').getValue() > 0){
                                                        var pTalla = Ext.getCmp('intTallaIngreso').getValue() / 100;
                                                        Ext.getCmp('intIMCIngreso').setValue(Ext.getCmp('intPesoIngreso').getValue()/(pTalla*pTalla));
                                                    }else{
                                                        Ext.getCmp('intIMCIngreso').setValue(0);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysPesoingreso',
                                        value: 'PESO (Kg) '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 60,
                                        minValue: 0,
                                        maxValue: 250,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        emptyText: '(Kg)',
                                        name:"PESO (Kg)",
                                        id: 'intPesoIngreso',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                if(pNew == null || pNew == 0){
                                                    Ext.getCmp('intPesoIngreso').setValue(null);
                                                    Ext.getCmp('intIMCIngreso').setValue(0);
                                                }else{
                                                    //peso [kg]/ estatura [m2]
                                                    if(Ext.getCmp('intTallaIngreso').getValue() > 0){
                                                        var pTalla = Ext.getCmp('intTallaIngreso').getValue() / 100;
                                                        Ext.getCmp('intIMCIngreso').setValue(Ext.getCmp('intPesoIngreso').getValue()/(pTalla*pTalla));
                                                    }else{
                                                        Ext.getCmp('intIMCIngreso').setValue(0);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysIMCIngreso',
                                        value: 'IMC '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 60,
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        readOnly: true,
                                        name: "IMC Ingreso",
                                        id: 'intIMCIngreso'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysPAIngreso',
                                        value: 'P. Abd.'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 60,
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        name: 'Perimetro Abdominal',
                                        allowBlank: true,
                                        id: 'strPAIngreso'
                                    }
                                ]
                            },
                            {
                                html: '<br><hr><br>'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Parcial Orina',
                                        fieldLabel: 'Parcial Orina',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEParcialorina'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        name: 'Resultado Pacial Orina',
                                        emptyText: 'Resultado',
                                        allowBlank: true,
                                        id: 'strPROGESPEParcialorinaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Colesterol Total',
                                        fieldLabel: 'Colesterol Total',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEColesterolTotal'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol Total',
                                        emptyText: 'Rango 20 - 700',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPEColesterolTotalRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Colesterol HDL',
                                        fieldLabel: 'Colesterol HDL',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEColesterolHDL'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol HDL',
                                        emptyText: 'Rango 10 - 500',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPEColesterolHDLRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Colesterol LDL',
                                        fieldLabel: 'Colesterol LDL',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEColesterolLDL'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol LDL',
                                        emptyText: 'Rango 10 - 500',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPEColesterolLDLRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Trigliceridos',
                                        fieldLabel: 'Trigliceridos',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPETrigliceridos'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Trigliceridos',
                                        emptyText: 'Rango 20 - 1000',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPETrigliceridosRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Hb Glicosilada',
                                        fieldLabel: 'Hb Glicosilada',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEHemoglobinaGlicosilada'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Hb Glicosilada',
                                        emptyText: 'Rango 5 - 20',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPEHemoglobinaGlicosiladaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Glicemia',
                                        fieldLabel: 'Glicemia',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEGlicemia'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Glicemia',
                                        emptyText: 'Rango 20 - 1000',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPEGlicemiaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Micro Albuminuria',
                                        fieldLabel: 'Micro Albuminuria',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEMicroAlbuminuria'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Micro Albuminuria',
                                        emptyText: 'Rango 0 - 700',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPEMicroAlbuminuriaRes'
                                    }
                                ]
                            },
                            /*{
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Urea',
                                        fieldLabel: 'Urea',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEUrea'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Urea',
                                        emptyText: 'Resultado',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPEUreaRes'
                                    }
                                ]
                            },*/
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Proteinas 24 horas',
                                        fieldLabel: 'Proteinas 24 horas',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEProteinas'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Proteinas 24 horas',
                                        emptyText: 'Resultado',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPEProteinasRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Ecografia Renal',
                                        fieldLabel: 'Ecografia Renal',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEEcografiaRenal'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Ecografia Renal',
                                        emptyText: 'Resultado',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPEEcografiaRenalRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Creatinina',
                                        fieldLabel: 'Creatinina',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPECreatinina'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Creatinina',
                                        emptyText: 'Rango 0,2 - 25',
                                        width: 200,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        id: 'strPROGESPECreatininaRes',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                if(pNew === null || pNew === 0){
                                                    Ext.getCmp('intPROGESPETFGIngreso').setValue(null);
                                                    Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue(null);
                                                }else{
                                                    var resultadoTFGIngreso = ((140 - AniosCumplidos) * Ext.getCmp('intEXAFISPeso').getValue()) / (72 * Ext.getCmp('strPROGESPECreatininaRes').getValue())
                                                    
                                                    if(Ext.getCmp('sysGeneroHC').getValue() === "FEMENINO"){
                                                        Ext.getCmp('intPROGESPETFGIngreso').setValue(resultadoTFGIngreso * 0.85);
                                                    }else{
                                                        Ext.getCmp('intPROGESPETFGIngreso').setValue(resultadoTFGIngreso);
                                                    }
                                                    
                                                    if(resultadoTFGIngreso < 15){
                                                        Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio V");
                                                    }else{
                                                        if(resultadoTFGIngreso < 30){
                                                            Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio IV");
                                                        }else{
                                                            if(resultadoTFGIngreso < 60){
                                                                Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio III");
                                                            }else{
                                                                if(resultadoTFGIngreso < 90){
                                                                    Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio II");
                                                                }else{
                                                                    Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio I");
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        name: 'T.F.G Ingreso',
                                        fieldLabel: 'T.F.G',
                                        emptyText: 'Resultado',
                                        width: 120,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'intPROGESPETFGIngreso'
                                    },
                                    {
                                        html: '-'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        readOnly: true,
                                        name: 'TFG CLASIFICACION',
                                        id: 'strPROGESPETFGIngresoCalsifica'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Datos Seguimiento Programa',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        labelSeparator: '',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'combo',
                                name: 'Nivel de Riesgo HTA Seguimiento',
                                fieldLabel: 'Riesgo HTA',
                                width: 70,
                                allowBlank: true,
                                store: stDatProgNivelRiesgo,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPENivelRiesgoHTASeguimiento'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Nivel de Riesgo DM Seguimiento',
                                        fieldLabel: 'Riesgo DM:',
                                        width: 70,
                                        allowBlank: true,
                                        store: stDatProgNivelRiesgo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPENivelRiesgoDMSeguimiento'
                                    },
                                    {
                                        html:'Tipo DM:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Tipo de DM Seguimiento',
                                        width: 150,
                                        allowBlank: true,
                                        store: stDatProgTipoDM,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETipoDMSeguimiento'
                                    },
                                    {
                                        html:'Tipo Insulina:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Tipo Insulina',
                                        width: 150,
                                        allowBlank: true,
                                        store: stDatProgTipoInsulina,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETipoDMInsulinaSeguimiento'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Nivel de Riesgo Nefroproteccion Seguimiento',
                                        fieldLabel: 'Riesgo Nefroproteccion:',
                                        width: 70,
                                        allowBlank: true,
                                        store: stDatProgNivelRiesgo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPENivelRiesgoNefroProteccionSeguimiento'
                                    },
                                    {
                                        html:'Estadio Nefroproteccion:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Estadio Nefroproteccion Seguimiento',
                                        width: 150,
                                        allowBlank: true,
                                        store: stDatProgEstadioNefroProteccion,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEEstadioNefroProteccionSeguimiento'
                                    }
                                ]
                            },
                            {
                                html: '<br>'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Parcial de Orina',
                                        name: 'Parcial de Orina',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeParcialorina',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoParcialorina'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        name: 'Resultado Pacial Orina',
                                        emptyText: 'Resultado',
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoParcialorinaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Colesterol Total',
                                        name: 'Colesterol Total',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeColesterolTotal',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoColesterolTotal'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol Total',
                                        emptyText: 'Rango 20 - 700',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoColesterolTotalRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Colesterol HDL',
                                        name: 'Colesterol HDL',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeColesterolHDL',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoColesterolHDL'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol HDL',
                                        emptyText: 'Rango 10 - 500',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoColesterolHDLRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Colesterol LDL',
                                        name: 'Colesterol LDL',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeColesterolLDL',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoColesterolLDL'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol LDL',
                                        emptyText: 'Rango 10 - 500',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoColesterolLDLRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Trigliceridos',
                                        name: 'Trigliceridos',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeTrigliceridos',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoTrigliceridos'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Trigliceridos',
                                        emptyText: 'Rango 20 - 1000',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoTrigliceridosRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Hb Glicosilada',
                                        name: 'Hb Glicosilada',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeHemoglobinaGlicosilada',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoHemoglobinaGlicosilada'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Hb Glicosilada',
                                        emptyText: 'Rango 5 - 20',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoHemoglobinaGlicosiladaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Glicemia',
                                        name: 'Glicemia',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeGlicemia',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoGlicemia'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Glicemia',
                                        emptyText: 'Rango 20 - 1000',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoGlicemiaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Micro Albuminuria',
                                        name: 'Micro Albuminuria',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeMicroAlbuminuria',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoMicroAlbuminuria'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Micro Albuminuria',
                                        emptyText: 'Rango 0 - 700',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoMicroAlbuminuriaRes'
                                    }
                                ]
                            },
                            /*{
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Urea',
                                        name: 'Urea',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeUrea',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoUrea'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Urea',
                                        emptyText: 'Resultado',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoUreaRes'
                                    }
                                ]
                            },*/
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Creatinina',
                                        name: 'Creatinina',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeCreatinina',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoCreatinina'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Creatinina',
                                        emptyText: 'Rango 0,2 - 25',
                                        width: 200,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoCreatininaRes',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                if(pNew === null || pNew === 0){
                                                    Ext.getCmp('strPROGESPETFGSeguimiento').setValue(null);
                                                    Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue(null);
                                                }else{
                                                    var resultadoTFGIngreso = ((140 - AniosCumplidos) * Ext.getCmp('intEXAFISPeso').getValue()) / (72 * Ext.getCmp('strPROGESPESeguimientoCreatininaRes').getValue())
                                                    
                                                    if(Ext.getCmp('sysGeneroHC').getValue() === "FEMENINO"){
                                                        Ext.getCmp('strPROGESPETFGSeguimiento').setValue(resultadoTFGIngreso * 0.85);
                                                    }else{
                                                        Ext.getCmp('strPROGESPETFGSeguimiento').setValue(resultadoTFGIngreso);
                                                    }
                                                    
                                                    if(resultadoTFGIngreso < 15){
                                                        Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').setValue("Estadio V");
                                                    }else{
                                                        if(resultadoTFGIngreso < 30){
                                                            Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').setValue("Estadio IV");
                                                        }else{
                                                            if(resultadoTFGIngreso < 60){
                                                                Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').setValue("Estadio III");
                                                            }else{
                                                                if(resultadoTFGIngreso < 90){
                                                                    Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').setValue("Estadio II");
                                                                }else{
                                                                    Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').setValue("Estadio I");
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        name: 'T.F.G Seguimiento',
                                        fieldLabel: 'T.F.G Seguimiento',
                                        emptyText: 'Resultado',
                                        width: 120,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'strPROGESPETFGSeguimiento'
                                    },
                                    {
                                        html: '-'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        readOnly: true,
                                        name: 'TFG CLASIFICACION',
                                        id: 'strPROGESPETFGSeguimientoCalsifica'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Metas Terapeuticas',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        id: 'fsMetasTerapeuticas',
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'table',
                                anchor: '100%',
                                padding: 0,
                                layoutConfig: {
                                    columns: 5
                                },
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 650,
                                        height: 300,
                                        labelWidth: 630,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        title: '<center>Concepto</center>',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Cifras de Tension Arterial menores de 140/90 mm Hg',
                                                width: 1,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaA'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Glicemia prepandrial entre 90 a 120 hg/dl',
                                                width: 1,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaB'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Hemoglicemia Glicosilada (HbA1) <7.0% Ideal 6,5%',
                                                width: 1,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaC'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Trigliceridos menor a 150 mg/dl',
                                                width: 1,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaD'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Colesterol LDL menor a 100 mg/dl',
                                                width: 1,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaE'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'HDL Mayor de 40 mg/dl en hombre y mayor de 50 mg/gl en mujeres',
                                                width: 1,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaF'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Microalbuminuria menor de 30 mg/dl',
                                                width: 1,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaG'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Perdida Gradual y Sostenida inicial de 5 a 10% del peso hasta alcanzar IMC 18.5 a 24.9 kg/m2',
                                                width: 1,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaH'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Perimetro de Cintura: hombres menor o igual a 90 cm, mujeres menor o igual a 80 cm',
                                                width: 1,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaI'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Manejo del estres, Desarrollo de habilidades para comunicacion asertiva y Solucion de problemas',
                                                width: 1,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaJ'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 80,
                                        height: 300,
                                        labelWidth: 1,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        title: '<center>Indicado</center>',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                name: 'Cumplido Cifras de Tension Arterial menores de 140/90 mm Hg',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'bolPROESPMetasCifras'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                name: 'Glicemia prepandrial entre 90 a 120 hg/dl',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'bolPROESPMetasGlicemia'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                name: 'Hemoglicemia Glicosilada (HbA1) <7.0% Ideal 6,5%',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'bolPROESPMetasHbA1'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                name: 'Trigliceridos menor a 150 mg/dl',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'bolPROESPMetasTrigliceridos'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                name: 'Colesterol LDL menor a 100 mg/dl',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'bolPROESPMetasLDL'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                name: 'HDL Mayor de 40 mg/dl en hombre y mayor de 50 mg/gl en mujeres',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'bolPROESPMetasHDL'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                name: 'Microalbuminuria menor de 30 mg/dl',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'bolPROESPMetasMicroalbuminuria'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                name: 'Perdida Gradual y Sostenida inicial de 5 a 10% del peso hasta alcanzar IMC 18.5 a 24.9 kg/m2',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'bolPROESPMetasIMC'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                name: 'Perimetro de Cintura: hombres menor o igual a 90 cm, mujeres menor o igual a 80 cm',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'bolPROESPMetasPerimetroCintura'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                name: 'Manejo del estres, Desarrollo de habilidades para comunicacion asertiva y Solucion de problemas',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'bolPROESPMetasManejoEstres'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 80,
                                        height: 300,
                                        labelWidth: 1,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        title: '<center>Cumplido</center>',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Cifras de Tension Arterial menores de 140/90 mm Hg',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'intPROESPCumplidosCifras',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Glicemia prepandrial entre 90 a 120 hg/dl',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'intPROESPCumplidosGlicemia',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Hemoglicemia Glicosilada (HbA1) <7.0% Ideal 6,5%',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'intPROESPCumplidosHbA1',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Trigliceridos menor a 150 mg/dl',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'intPROESPCumplidosTrigliceridos',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Colesterol LDL menor a 100 mg/dl',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'intPROESPCumplidosLDL',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido HDL Mayor de 40 mg/dl en hombre y mayor de 50 mg/gl en mujeres',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'intPROESPCumplidosHDL',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Microalbuminuria menor de 30 mg/dl',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'intPROESPCumplidosMicroalbuminuria',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Perdida Gradual y Sostenida inicial de 5 a 10% del peso hasta alcanzar IMC 18.5 a 24.9 kg/m2',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'intPROESPCumplidosIMC',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Perimetro de Cintura: hombres menor o igual a 90 cm, mujeres menor o igual a 80 cm',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'intPROESPCumplidospPerimetroCintura',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Manejo del estres, Desarrollo de habilidades para comunicacion asertiva y Solucion de problemas',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'intPROESPCumplidosEstres',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                anchor: '100%',
                                width: 880,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,
                                allowBlank: false,
                                id: 'memPROGESPEMetasTerapeuticasObservaciones'
                            },
                            {
                                xtype: 'numberfield',
                                width: 50,
                                fieldLabel: 'Numero Metas Cumplidas',
                                name: 'Numero Metas Cumplidas',
                                minValue: 0,
                                allowBlank: false,
                                style: 'text-align:center;',
                                id: 'intPROGESPENumCumplimientoMetas'
                            }
                        ]
                    }
                ]
            }
        ];
        pnProgramasEspecialesUi.superclass.initComponent.call(this);
    }
});


function calculoEstadioHTA(){
   if(Ext.getCmp('intEXAFISTASentadoSistolica').getValue() >= 160 || Ext.getCmp('intEXAFISTASentadoDiastolica').getValue() >= 100 || Ext.getCmp('intEXAFISTAdePieSistolica').getValue() >= 160 || Ext.getCmp('intEXAFISTAdePieDiastolica').getValue() >= 100){
       Ext.getCmp('strPROGESPEDxHTAEstadio').setValue("ESTADIO II");
   }else{
       if(Ext.getCmp('intEXAFISTASentadoSistolica').getValue() >= 140 || Ext.getCmp('intEXAFISTASentadoDiastolica').getValue() >= 90 || Ext.getCmp('intEXAFISTAdePieSistolica').getValue() >= 140 || Ext.getCmp('intEXAFISTAdePieDiastolica').getValue() >= 90){
           Ext.getCmp('strPROGESPEDxHTAEstadio').setValue("ESTADIO I");
       }else{
           if(Ext.getCmp('intEXAFISTASentadoSistolica').getValue() >= 120 || Ext.getCmp('intEXAFISTASentadoDiastolica').getValue() >= 80 || Ext.getCmp('intEXAFISTAdePieSistolica').getValue() >= 120 || Ext.getCmp('intEXAFISTAdePieDiastolica').getValue() >= 80){
               Ext.getCmp('strPROGESPEDxHTAEstadio').setValue("PREHIPERTENSION")
           }else{
               Ext.getCmp('strPROGESPEDxHTAEstadio').setValue("NORMAL")
           }
       }
   }
}

function calculoMetas(){
    
    var totalMetasCumplidas = (parseInt(Ext.getCmp('intPROESPCumplidosEstres').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidospPerimetroCintura').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidosIMC').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidosMicroalbuminuria').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidosHDL').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidosLDL').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidosTrigliceridos').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidosHbA1').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidosGlicemia').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidosCifras').getValue()));
    Ext.getCmp('intPROGESPENumCumplimientoMetas').setValue(totalMetasCumplidas);
}