/*
* @category    Panel Planificacion Familiar
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnPlanificacionFamiliarUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnPlanificacionFamiliar',
    initComponent: function() {
        this.items = [
            {
                xtype: 'panel',
                anchor: '100%',
                autoHeight: true,
                layout: 'form',
                labelWidth: 260,
                padding: 5,
                items: [
                    {
                        xtype: 'combo',
                        labelStyle: 'background-color:#FF0; color:#F00; text-decoration:blink;',
                        fieldLabel: 'Registrar HC Planificacion Familiar?',
                        name: 'Registrar HC Planificacion Familiar?',
                        width: 60,
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strRegistrarPlanificacionFamiliar',
                        listeners:{
                            change : function( t, newValue, oldValue){
                                if(newValue == "NO"){
                                    Ext.getCmp('fsPlanificacionFamiliar').setVisible(false);
                                    Ext.getCmp('fecPLANIFAMIIngreso').allowBlank = true;
                                    Ext.getCmp('strPLANIFAMIMetodoPlanifica').allowBlank = true;
                                    Ext.getCmp('fecPLANIFAMICitologia').allowBlank = true;
                                    Ext.getCmp('strPLANIFAMICitologiaRes').allowBlank = true;
                                    Ext.getCmp('strPLANIFAMIToleraMetodo').allowBlank = true;
                                    Ext.getCmp('strPLANIFAMICambioMetodo').allowBlank = true;
                                    Ext.getCmp('strPLANIFAMINuevoMetodo').allowBlank = true;
                                    Ext.getCmp('fecPLANIFAMIFecCambioMetodo').allowBlank = true;
                                    Ext.getCmp('memPLANIFAMIPlan').allowBlank = true;
                                    Ext.getCmp('sysPLANIFAMIDiag').allowBlank = true;
                                    Ext.getCmp('sysPLANIFAMIDiag').setValue(null);
                                    Ext.getCmp('fecPLANIFAMIIngreso').setValue(null);
                                    Ext.getCmp('strPLANIFAMIMetodoPlanifica').setValue(null);
                                    Ext.getCmp('fecPLANIFAMICitologia').setValue(null);
                                    Ext.getCmp('strPLANIFAMICitologiaRes').setValue(null);
                                    Ext.getCmp('strPLANIFAMIToleraMetodo').setValue(null);
                                    Ext.getCmp('strPLANIFAMICambioMetodo').setValue(null);
                                    Ext.getCmp('strPLANIFAMINuevoMetodo').setValue(null);
                                    Ext.getCmp('fecPLANIFAMIFecCambioMetodo').setValue(null);
                                    Ext.getCmp('memPLANIFAMIPlan').setValue(null);
                                    Ext.getCmp('fecPLANIFAMIIngreso').disable();
                                    Ext.getCmp('strPLANIFAMIMetodoPlanifica').disable();
                                    Ext.getCmp('fecPLANIFAMICitologia').disable();
                                    Ext.getCmp('strPLANIFAMICitologiaRes').disable();
                                    Ext.getCmp('strPLANIFAMIToleraMetodo').disable();
                                    Ext.getCmp('strPLANIFAMICambioMetodo').disable();
                                    Ext.getCmp('strPLANIFAMINuevoMetodo').disable();
                                    Ext.getCmp('fecPLANIFAMIFecCambioMetodo').disable();
                                    Ext.getCmp('memPLANIFAMIPlan').disable();
                                    Ext.getCmp('sysPLANIFAMIDiag').disable();
                                    Ext.getCmp('sysPLANIFAMIDiag').clearInvalid();
                                    Ext.getCmp('fecPLANIFAMIIngreso').clearInvalid();
                                    Ext.getCmp('strPLANIFAMIMetodoPlanifica').clearInvalid();
                                    Ext.getCmp('fecPLANIFAMICitologia').clearInvalid();
                                    Ext.getCmp('strPLANIFAMICitologiaRes').clearInvalid();
                                    Ext.getCmp('strPLANIFAMIToleraMetodo').clearInvalid();
                                    Ext.getCmp('strPLANIFAMICambioMetodo').clearInvalid();
                                    Ext.getCmp('strPLANIFAMINuevoMetodo').clearInvalid();
                                    Ext.getCmp('fecPLANIFAMIFecCambioMetodo').clearInvalid();
                                    Ext.getCmp('memPLANIFAMIPlan').clearInvalid();

                                }else{
                                    Ext.getCmp('fsPlanificacionFamiliar').setVisible(true);
                                    Ext.getCmp('fecPLANIFAMIIngreso').allowBlank = true;
                                    Ext.getCmp('strPLANIFAMIMetodoPlanifica').allowBlank = false;
                                    Ext.getCmp('fecPLANIFAMICitologia').allowBlank = true;
                                    Ext.getCmp('strPLANIFAMICitologiaRes').allowBlank = true;
                                    Ext.getCmp('strPLANIFAMIToleraMetodo').allowBlank = true;
                                    Ext.getCmp('strPLANIFAMICambioMetodo').allowBlank = false;
                                    Ext.getCmp('strPLANIFAMINuevoMetodo').allowBlank = true;
                                    Ext.getCmp('fecPLANIFAMIFecCambioMetodo').allowBlank = true;
                                    Ext.getCmp('memPLANIFAMIPlan').allowBlank = false;
                                    Ext.getCmp('sysPLANIFAMIDiag').allowBlank = false;
                                    Ext.getCmp('sysPLANIFAMIDiag').enable();
                                    Ext.getCmp('fecPLANIFAMIIngreso').enable();
                                    Ext.getCmp('strPLANIFAMIMetodoPlanifica').enable();
                                    Ext.getCmp('fecPLANIFAMICitologia').enable();
                                    Ext.getCmp('strPLANIFAMICitologiaRes').enable();
                                    Ext.getCmp('strPLANIFAMIToleraMetodo').enable();
                                    Ext.getCmp('strPLANIFAMICambioMetodo').enable();
                                    Ext.getCmp('strPLANIFAMINuevoMetodo').enable();
                                    Ext.getCmp('fecPLANIFAMIFecCambioMetodo').enable();
                                    Ext.getCmp('memPLANIFAMIPlan').enable();
                                }
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'PROGRAMA: PLANIFICACION FAMILIAR',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 5,
                id: 'fsPlanificacionFamiliar',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                fieldLabel: 'Fecha Ingreso al Programa',
                                name: 'Fecha Ingreso al Programa',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecPLANIFAMIIngreso'
                            },
                            {
                                html: 'Metodo Anticonceptivo:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Metodo Planificacion',
                                width: 190,
                                allowBlank: true,
                                store: 'StoreMetodosPlanificacion',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPLANIFAMIMetodoPlanifica'
                            },
                            {
                                html: 'Tolera Metodo'
                            },
                            {
                                xtype: 'combo',
                                name: 'Tolera Metodo',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPLANIFAMIToleraMetodo'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                fieldLabel: 'Ultima Citologia',
                                name: 'Ultima Citologia',
                                allowBlank: true,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecPLANIFAMICitologia'
                            },
                            {
                                html: 'Resultado:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Resultado',
                                width: 150,
                                allowBlank: true,
                                store: stResultadoCitologia,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPLANIFAMICitologiaRes'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'Cambio de Metodo',
                                fieldLabel: 'Cambio de Metodo',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPLANIFAMICambioMetodo',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue == "NO"){
                                            Ext.getCmp('strPLANIFAMINuevoMetodo').allowBlank = true;
                                            Ext.getCmp('fecPLANIFAMIFecCambioMetodo').allowBlank = true;
                                            Ext.getCmp('strPLANIFAMINuevoMetodo').setValue(null);
                                            Ext.getCmp('fecPLANIFAMIFecCambioMetodo').setValue(null);
                                            Ext.getCmp('strPLANIFAMINuevoMetodo').disable();
                                            Ext.getCmp('fecPLANIFAMIFecCambioMetodo').disable();
                                            Ext.getCmp('strPLANIFAMINuevoMetodo').clearInvalid();
                                            Ext.getCmp('fecPLANIFAMIFecCambioMetodo').clearInvalid();
                                            }else{
                                            Ext.getCmp('strPLANIFAMINuevoMetodo').enable();
                                            Ext.getCmp('fecPLANIFAMIFecCambioMetodo').enable();
                                            Ext.getCmp('strPLANIFAMINuevoMetodo').allowBlank = false;
                                            Ext.getCmp('fecPLANIFAMIFecCambioMetodo').allowBlank = false;
                                            }
                                    }
                                }
                            },
                            {
                                html: 'Nuevo Metodo:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Nuevo Metodo',
                                width: 190,
                                allowBlank: true,
                                store: 'StoreMetodosPlanificacion',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPLANIFAMINuevoMetodo'
                            },
                            {
                                html: 'Fecha Cambio:'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Fecha Cambio Metodo',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecPLANIFAMIFecCambioMetodo'
                            }
                        ]
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        width: 880,
                        fieldLabel: 'PLAN',
                        name: 'PLAN',
                        height: 100,
                        allowBlank: true,
                        id: 'memPLANIFAMIPlan'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                                {
                                xtype: 'textfield',
                                width: 96,
                                allowBlank: true,
                                fieldLabel: 'Diagnostico',
                                id: 'sysPLANIFAMIDiag',
                                listeners:{
                                    specialkey: function(f,e){
                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                        {
                                            if (f.getValue() != "" && f.getValue() != null){
                                                Ext.Ajax.request({
                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                    params:{
                                                        task: 'BUSCAR',
                                                        pCodigo: f.getValue().toUpperCase()
                                                    },
                                                    success: function(response,options)
                                                    {
                                                        var el = Ext.get('response'); // get the LOG
                                                        var Respuesta = response.responseText;
                                                        var Contenido = Respuesta.split('^');
                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                            Ext.getCmp('sysPLANIFAMIDiag').setValue(null);
                                                            Ext.getCmp('sysPLANIFAMIDiagNom').setValue(null);
                                                        } else {
                                                            Ext.getCmp('sysPLANIFAMIDiag').setValue(Contenido[0]);
                                                            Ext.getCmp('sysPLANIFAMIDiagNom').setValue(Contenido[1]);
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        var el = Ext.get('response');
                                                        Ext.getCmp('sysPLANIFAMIDiag').setValue(null);
                                                        Ext.getCmp('sysPLANIFAMIDiagNom').setValue(null);
                                                    },
                                                    scope:this //bind the callbacks
                                                });
                                            }else{
                                                Ext.getCmp('sysPLANIFAMIDiag').setValue(null);
                                                Ext.getCmp('sysPLANIFAMIDiagNom').setValue(null);
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'textarea',
                                readOnly: true,
                                width: 625,
                                height: 22,
                                id: 'sysPLANIFAMIDiagNom'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Diagnostico Principal',
                                listeners:{
                                    click : function(){
                                        buscarcie10('sysPLANIFAMIDiag','sysPLANIFAMIDiagNom');
                                    }
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        pnPlanificacionFamiliarUi.superclass.initComponent.call(this);
    }
});
