/*
* @category    Formulario Modelo Toma e Interpretacion de Citologia de Cuello Uterino
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winCitologiaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Toma e Interpretacion de Citologia de Cuello Uterino ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winCitologia',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        
        //Store Locales
        var dataResultadoCitologia = [
            ['NO REALIZADA'],
            ['NORMAL'],
            ['ANORMAL']
        ];
        var stResultadoCitologia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stResultadoCitologia.loadData(dataResultadoCitologia);
        
        
        var dataProfesional = [
            ['Citotecnologo'],
            ['Patologo']
        ];
        var stProfesional = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stProfesional.loadData(dataProfesional);
        
        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'IDENTIFICACION DEL PACIENTE',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaIdentifica',
                                layout: 'form',
                                items:[
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroHC'
                                            },
                                            {
                                                html: 'Fecha Nac:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Edad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 350,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEdadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Ocupación',
                                                id: 'sysOcupacionHC'
                                            },
                                            {
                                                html: 'Discapacidad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysDiscapacidadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Estado Civil',
                                                id: 'sysEstadoCivilHC'
                                            },
                                            {
                                                html: 'Escolaridad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 380,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEscolaridadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Dirección',
                                                id: 'sysDireccionHC'
                                            },
                                            {
                                                html: 'Telefono:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysTelefonoHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 380,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Etnia',
                                                id: 'sysEtniaHC'
                                            },
                                            {
                                                html: 'Estrato:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEstratoHC'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'EVOLUCION',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        height: 635,
                                        id: 'frmHC',
                                        padding: 10,
                                        labelWidth: 120,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                width: 120,
                                                fieldLabel: 'Fecha Toma Citologia',
                                                name: 'Fecha Toma Citologia',
                                                allowBlank: true,
                                                disabledDates: '',
                                                emptyText: '(dia/mes/año) ',
                                                style: 'text-align:center;',
                                                id: 'fecCITFecCitologia'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Antecedentes',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Lactancia Actual', 
                                                                name: 'Lactancia Actual',
                                                                width: 60,
                                                                allowBlank: false,
                                                                value:'NO',
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCITLactancia'
                                                            },
                                                            {
                                                                html: 'Fecha Ultima Mestruacion'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha Ultima Mestruacion',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecCITFecUltMestruacion'
                                                            },
                                                            {
                                                                html: '&nbsp;&nbsp;-&nbsp;&nbsp;G:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'G',
                                                                emptyText: 'Gestaciones', 
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 20,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intCITGestaciones'
                                                            },
                                                            {
                                                                html: 'P:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'P',
                                                                emptyText: 'Partos', 
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 20,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intCITPartos'
                                                            },
                                                            {
                                                                html: 'A:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'A',
                                                                emptyText: 'Abortos', 
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 20,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intCITAbortos'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                name: 'Embarazo Actual',
                                                                fieldLabel: 'Embarazo Actual', 
                                                                width: 60,
                                                                allowBlank: false,
                                                                value:'NO',
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCITEmbarazoActual'
                                                            },
                                                            {
                                                                html: 'Metodo Planificacion'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Metodo Planificacion',
                                                                width: 200,
                                                                allowBlank: false,
                                                                store: 'StoreMetodosPlanificacion',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCITMetodoPlanifica'
                                                            },
                                                            {
                                                                html: 'Tiempo de Uso'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Tiempo de Uso',
                                                                width: 150,
                                                                allowBlank: true,
                                                                id: 'strCITTiempoUso'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha Ultima Citologia',
                                                                fieldLabel: 'Fecha Ultima Citologia',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecCITFecUltCitologia'
                                                            },
                                                            {
                                                                html: 'Resultado:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Resultado',
                                                                width: 150,
                                                                allowBlank: false,
                                                                store: stResultadoCitologia,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCITResultadoCitologia'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Procedimientos Anteriores en Cuello',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                layoutConfig: {
                                                    columns: 2
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width: 420,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Cauterizacion',
                                                                        name: 'Cauterizacion',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITCauterizacion',
                                                                        listeners:{
                                                                            check: function(t, c){
                                                                                if(c==true){
                                                                                    Ext.getCmp('fecCITCauterizacionFec').enable();
                                                                                    Ext.getCmp('fecCITCauterizacionFec').allowBlank = false;
                                                                                }else{
                                                                                    Ext.getCmp('fecCITCauterizacionFec').disable();
                                                                                    Ext.getCmp('fecCITCauterizacionFec').clearInvalid();
                                                                                    Ext.getCmp('fecCITCauterizacionFec').setValue(null);
                                                                                    Ext.getCmp('fecCITCauterizacionFec').allowBlank = true;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        disabledDates: '',
                                                                        disabled: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCITCauterizacionFec'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Histerectomia',
                                                                        name: 'Histerectomia',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITHisterectomia',
                                                                        listeners:{
                                                                            check: function(t, c){
                                                                                if(c==true){
                                                                                    Ext.getCmp('fecCITHisterectomiaFec').enable();
                                                                                    Ext.getCmp('fecCITHisterectomiaFec').allowBlank = false;
                                                                                }else{
                                                                                    Ext.getCmp('fecCITHisterectomiaFec').disable();
                                                                                    Ext.getCmp('fecCITHisterectomiaFec').clearInvalid();
                                                                                    Ext.getCmp('fecCITHisterectomiaFec').setValue(null);
                                                                                    Ext.getCmp('fecCITHisterectomiaFec').allowBlank = true;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        disabledDates: '',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCITHisterectomiaFec'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Vaporizacion',
                                                                        name: 'Vaporizacion',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITVaporizacion',
                                                                        listeners:{
                                                                            check: function(t, c){
                                                                                if(c==true){
                                                                                    Ext.getCmp('fecCITVaporizacionFec').enable();
                                                                                    Ext.getCmp('fecCITVaporizacionFec').allowBlank = false;
                                                                                }else{
                                                                                    Ext.getCmp('fecCITVaporizacionFec').disable();
                                                                                    Ext.getCmp('fecCITVaporizacionFec').clearInvalid();
                                                                                    Ext.getCmp('fecCITVaporizacionFec').setValue(null);
                                                                                    Ext.getCmp('fecCITVaporizacionFec').allowBlank = true;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        disabledDates: '',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCITVaporizacionFec'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Conizacion',
                                                                        name: 'Conizacion',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITConizacion',
                                                                        listeners:{
                                                                            check: function(t, c){
                                                                                if(c==true){
                                                                                    Ext.getCmp('fecCITConizacionFec').enable();
                                                                                    Ext.getCmp('fecCITConizacionFec').allowBlank = false;
                                                                                }else{
                                                                                    Ext.getCmp('fecCITConizacionFec').disable();
                                                                                    Ext.getCmp('fecCITConizacionFec').clearInvalid();
                                                                                    Ext.getCmp('fecCITConizacionFec').setValue(null);
                                                                                    Ext.getCmp('fecCITConizacionFec').allowBlank = true;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        disabledDates: '',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCITConizacionFec'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Crioterapia',
                                                                        name: 'Crioterapia',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITCrioterapia',
                                                                        listeners:{
                                                                            check: function(t, c){
                                                                                if(c==true){
                                                                                    Ext.getCmp('fecCITCrioterapiaFec').enable();
                                                                                    Ext.getCmp('fecCITCrioterapiaFec').allowBlank = false;
                                                                                }else{
                                                                                    Ext.getCmp('fecCITCrioterapiaFec').disable();
                                                                                    Ext.getCmp('fecCITCrioterapiaFec').clearInvalid();
                                                                                    Ext.getCmp('fecCITCrioterapiaFec').setValue(null);
                                                                                    Ext.getCmp('fecCITCrioterapiaFec').allowBlank = true;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        disabledDates: '',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCITCrioterapiaFec'
                                                                    }
                                                                ]
                                                            }
                                                            
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width: 420,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Radioterapia',
                                                                        name: 'Radioterapia',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITRadioterapia',
                                                                        listeners:{
                                                                            check: function(t, c){
                                                                                if(c==true){
                                                                                    Ext.getCmp('fecCITRadioterapiaFec').enable();
                                                                                    Ext.getCmp('fecCITRadioterapiaFec').allowBlank = false;
                                                                                }else{
                                                                                    Ext.getCmp('fecCITRadioterapiaFec').disable();
                                                                                    Ext.getCmp('fecCITRadioterapiaFec').clearInvalid();
                                                                                    Ext.getCmp('fecCITRadioterapiaFec').setValue(null);
                                                                                    Ext.getCmp('fecCITRadioterapiaFec').allowBlank = true;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        disabledDates: '',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCITRadioterapiaFec'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [        
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Tto Hormonal',
                                                                        name: 'Tto Hormonal',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITTtoHormonal',
                                                                        listeners:{
                                                                            check: function(t, c){
                                                                                if(c==true){
                                                                                    Ext.getCmp('fecCITTtoHormonalFec').enable();
                                                                                    Ext.getCmp('fecCITTtoHormonalFec').allowBlank = false;
                                                                                }else{
                                                                                    Ext.getCmp('fecCITTtoHormonalFec').disable();
                                                                                    Ext.getCmp('fecCITTtoHormonalFec').clearInvalid();
                                                                                    Ext.getCmp('fecCITTtoHormonalFec').setValue(null);
                                                                                    Ext.getCmp('fecCITTtoHormonalFec').allowBlank = true;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        disabledDates: '',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCITTtoHormonalFec'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Biopsia',
                                                                        name: 'Biopsia',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITBiopsia',
                                                                        listeners:{
                                                                            check: function(t, c){
                                                                                if(c==true){
                                                                                    Ext.getCmp('fecCITBiopsiaFec').enable();
                                                                                    Ext.getCmp('fecCITBiopsiaFec').allowBlank = false;
                                                                                }else{
                                                                                    Ext.getCmp('fecCITBiopsiaFec').disable();
                                                                                    Ext.getCmp('fecCITBiopsiaFec').clearInvalid();
                                                                                    Ext.getCmp('fecCITBiopsiaFec').setValue(null);
                                                                                    Ext.getCmp('fecCITBiopsiaFec').allowBlank = true;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        disabledDates: '',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCITBiopsiaFec'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Colposcopia',
                                                                        name: 'Colposcopia',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITColposcopia',
                                                                        listeners:{
                                                                            check: function(t, c){
                                                                                if(c==true){
                                                                                    Ext.getCmp('fecCITColposcopiaFec').enable();
                                                                                    Ext.getCmp('fecCITColposcopiaFec').allowBlank = false;
                                                                                }else{
                                                                                    Ext.getCmp('fecCITColposcopiaFec').disable();
                                                                                    Ext.getCmp('fecCITColposcopiaFec').clearInvalid();
                                                                                    Ext.getCmp('fecCITColposcopiaFec').setValue(null);
                                                                                    Ext.getCmp('fecCITColposcopiaFec').allowBlank = true;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        disabledDates: '',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCITColposcopiaFec'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Aspecto del Cuello',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 3,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Ausente',
                                                                        name: 'Ausente',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITAusente'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Sano',
                                                                        name: 'Sano',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITSano'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Atrofico',
                                                                        name: 'Atrofico',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITAtrofico'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Congestivo',
                                                                        name: 'Congestivo',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITCongestivo'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Ulcerado',
                                                                        name: 'Ulcerado',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITUlcerado'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Polipo',
                                                                        name: 'Polipo',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITPolipo'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Masa',
                                                                        name: 'Masa',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITMasa'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'Observaciones',
                                                name: 'Observaciones',
                                                height: 100,            
                                                allowBlank: true,
                                                id: 'memCITObservacionesToma'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INTERPRETACION SISTEMA BETHESDA 2001',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'A. Calidad de la Muestra',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        labelWidth: 400,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Satisfactoria (celulas endocervicales / Zona de transformacien presente',
                                                                name: 'Satisfactoria (celulas endocervicales / Zona de transformacien presente',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITCalidad1'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Satisfactoria (celulas endocervicales / Zona de transformacien ausente)',
                                                                name: 'Satisfactoria (celulas endocervicales / Zona de transformacien ausente)',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITCalidad2'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Insatisfactoria',
                                                                name: 'Insatisfactoria',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITCalidad3'
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Rechazada',
                                                                        name: 'Rechazada',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCITCalidad4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        emptyText: 'Causa',
                                                                        name: 'Causa',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        id: 'strCITCausa'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'B. Categorizacion General',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        labelWidth: 400,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: '1. Negativa para lesien intraepitelial o malignidad',
                                                                name: '1. Negativa para lesien intraepitelial o malignidad',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITCategorizacion1'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: '2. Anormalidades celulares epiteliales',
                                                                name: '2. Anormalidades celulares epiteliales',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITCategorizacion2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'C. Microorganismos',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        labelWidth: 400,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Trichomona Vaginalis',
                                                                name: 'Trichomona Vaginalis',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITMicroorganismos1'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Hongos compatibles con cendida s.p.',
                                                                name: 'Hongos compatibles con cendida s.p.',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITMicroorganismos2'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Cambios de la flora vaginal sugestiva de vaginosis bacteriana',
                                                                name: 'Cambios de la flora vaginal sugestiva de vaginosis bacteriana',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITMicroorganismos3'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Bacterias Compatible con Actimomices s.p.',
                                                                name: 'Bacterias Compatible con Actimomices s.p.',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITMicroorganismos4'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Efectos citopeticos por virus de herpes simple',
                                                                name: 'Efectos citopeticos por virus de herpes simple',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITMicroorganismos5'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'No se observa flora patogena',
                                                                name: 'No se observa flora patogena',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITMicroorganismos6'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'D. Otros Hallazgos no Neoplasticos',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        labelWidth: 400,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Cambios celulares reactivos asociados a inflamacien',
                                                                name: 'Cambios celulares reactivos asociados a inflamacien',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITOtrosHallazgos1'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Cambios celulares reactivos asociados a radiacien',
                                                                name: 'Cambios celulares reactivos asociados a radiacien',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITOtrosHallazgos2'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Cambios celulares asociados a DIU',
                                                                name: 'Cambios celulares asociados a DIU',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITOtrosHallazgos3'
                                                            },
                                                                        
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Celulas glandulares post histerectomea',
                                                                name: 'Celulas glandulares post histerectomea',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITOtrosHallazgos4'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Atrofia',
                                                                name: 'Atrofia',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITOtrosHallazgos5'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Otros Hallazgos (celulas endometriales en mujeres > 40 años)',
                                                                name: 'Otros Hallazgos (celulas endometriales en mujeres > 40 años)',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITOtrosHallazgos6'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'E. Anormalidades en Celulas Escamosas',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        labelWidth: 400,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Atipias de celulas escamosas de significado indeterminado (ASCUS)',
                                                                name: 'Atipias de celulas escamosas de significado indeterminado (ASCUS)',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidades1'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Atipias en celulas escamosas de significado indeterminado, no se puede excluir lesien de alto grado (ASC-H)',
                                                                name: 'Atipias en celulas escamosas de significado indeterminado, no se puede excluir lesien de alto grado (ASC-H)',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidades2'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Lesien escamosa intraepitelial de bajo grado LEI BG (VPH, NIC I)',
                                                                name: 'Lesien escamosa intraepitelial de bajo grado LEI BG (VPH, NIC I)',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidades3'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Lesien escamosa intraepitelial de alto grado LEI AG (NIC II, NIC III, Carcinoma In situ)',
                                                                name: 'Lesien escamosa intraepitelial de alto grado LEI AG (NIC II, NIC III, Carcinoma In situ)',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidades4'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Lesien escamosa intraepitelial de alto grado, sospechosa de infiltracien',
                                                                name: 'Lesien escamosa intraepitelial de alto grado, sospechosa de infiltracien',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidades5'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Carcinoma escamocelular',
                                                                name: 'Carcinoma escamocelular',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidades6'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'E. Anormalidades en Celulas Glandulares',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        labelWidth: 400,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Atipia de celulas endocervicales (ACG) sin especificar',
                                                                name: 'Atipia de celulas endocervicales (ACG) sin especificar',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidadesGlandulares1'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Atipia de celulas endometriales (ACG) sin especificar',
                                                                name: 'Atipia de celulas endometriales (ACG) sin especificar',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidadesGlandulares2'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Atipia de celulas glandulares (ACG) sin especificar',
                                                                name: 'Atipia de celulas glandulares (ACG) sin especificar',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidadesGlandulares3'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Atipia de celulas endocervicales sugestivas de neoplasia',
                                                                name: 'Atipia de celulas endocervicales sugestivas de neoplasia',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidadesGlandulares4'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Atipia de celulas glandulares sugestivas de neoplasia',
                                                                name: 'Atipia de celulas glandulares sugestivas de neoplasia',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidadesGlandulares5'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Adenocarcinoma endocervical in situ',
                                                                name: 'Adenocarcinoma endocervical in situ',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidadesGlandulares6'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Adenocarcinoma endocervical infiltrante',
                                                                name: 'Adenocarcinoma endocervical infiltrante',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidadesGlandulares7'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Adenocarcinoma endometrial',
                                                                name: 'Adenocarcinoma endometrial',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidadesGlandulares8'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Adenocarcinoma extrauterino',
                                                                name: 'Adenocarcinoma extrauterino',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidadesGlandulares9'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Adenocarcinoma sin especificar NOS',
                                                                name: 'Adenocarcinoma sin especificar NOS',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidadesGlandulares10'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Otras neoplasias malignas',
                                                                name: 'Otras neoplasias malignas',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCITAnormalidadesGlandulares11'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 780,
                                                        fieldLabel: 'Observaciones y Recomendaciones',
                                                        name: 'Observaciones y Recomendaciones',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memCITObservacionesRes'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'DATOS PROFESIONAL QUIEN REALIZA LA LECTURA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Profesional Primera Lectura',
                                                                fieldLabel: 'Profesional Primera Lectura',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: stProfesional,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCITProflectura'
                                                            },
                                                            {
                                                                html: 'Apellidos y Nombres:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Apellidos y  Nombres',
                                                                width: 200,
                                                                allowBlank: true,
                                                                id: 'strCITNombreLectura'
                                                            },
                                                            {
                                                                html: 'Registro:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Registro',
                                                                width: 75,
                                                                allowBlank: true,
                                                                id: 'strCITRegistroLectura'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecCITFechaLectura'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Segunda Lectura:',
                                                                fieldLabel: 'Profesional Segunda Lectura:',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: stProfesional,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCITProflectura2'
                                                            },
                                                            {
                                                                html: 'Apellidos y Nombres:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Apellidos y  Nombres',
                                                                width: 200,
                                                                allowBlank: true,
                                                                id: 'strCITNombreLectura2'
                                                            },
                                                            {
                                                                html: 'Registro:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Registro',
                                                                width: 75,
                                                                allowBlank: true,
                                                                id: 'strCITRegistroLectura2'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecCITFechaLectura2'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'datefield',
                                                width: 120,
                                                fieldLabel: 'Fecha Entrega Resultado',
                                                name: 'Fecha Entrega Resultado',
                                                allowBlank: true,
                                                disabledDates: '',
                                                emptyText: '(dia/mes/año) ',
                                                style: 'text-align:center;',
                                                id: 'fecCITFechaEntregaRes'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winCitologia').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winCitologia').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosTomaCitologia();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosTomaCitologia();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winCitologiaUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosTomaCitologia(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar_tomacitologia',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pDiagppal: "Z124",
                pDiagrel1: null,
                pDiagrel2: null,
                pDiagrel3: null,
                pAmbito: "1",
                pFinalidadProced: "4",
                pPersonalAtiende: "3",
                pFormaActo: "1",
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pCITFecCitologia:  Ext.getCmp('fecCITFecCitologia').getValue(),
                pCITLactancia:  Ext.getCmp('strCITLactancia').getValue(),
                pCITFecUltMestruacion:  Ext.getCmp('fecCITFecUltMestruacion').getValue(),
                pCITGestaciones:  Ext.getCmp('intCITGestaciones').getValue(),
                pCITPartos:  Ext.getCmp('intCITPartos').getValue(),
                pCITAbortos:  Ext.getCmp('intCITAbortos').getValue(),
                pCITEmbarazoActual:  Ext.getCmp('strCITEmbarazoActual').getValue(),
                pCITMetodoPlanifica:  Ext.getCmp('strCITMetodoPlanifica').getValue(),
                pCITTiempoUso:  Ext.getCmp('strCITTiempoUso').getValue(),
                pCITFecUltCitologia:  Ext.getCmp('fecCITFecUltCitologia').getValue(),
                pCITResultadoCitologia:  Ext.getCmp('strCITResultadoCitologia').getValue(),
                pCITCauterizacion:  Ext.getCmp('bolCITCauterizacion').getValue(),
                pCITCauterizacionFec:  Ext.getCmp('fecCITCauterizacionFec').getValue(),
                pCITHisterectomia:  Ext.getCmp('bolCITHisterectomia').getValue(),
                pCITHisterectomiaFec:  Ext.getCmp('fecCITHisterectomiaFec').getValue(),
                pCITVaporizacion:  Ext.getCmp('bolCITVaporizacion').getValue(),
                pCITVaporizacionFec:  Ext.getCmp('fecCITVaporizacionFec').getValue(),
                pCITConizacion:  Ext.getCmp('bolCITConizacion').getValue(),
                pCITConizacionFec:  Ext.getCmp('fecCITConizacionFec').getValue(),
                pCITCrioterapia:  Ext.getCmp('bolCITCrioterapia').getValue(),
                pCITCrioterapiaFec:  Ext.getCmp('fecCITCrioterapiaFec').getValue(),
                pCITRadioterapia:  Ext.getCmp('bolCITRadioterapia').getValue(),
                pCITRadioterapiaFec:  Ext.getCmp('fecCITRadioterapiaFec').getValue(),
                pCITTtoHormonal:  Ext.getCmp('bolCITTtoHormonal').getValue(),
                pCITTtoHormonalFec:  Ext.getCmp('fecCITTtoHormonalFec').getValue(),
                pCITBiopsia:  Ext.getCmp('bolCITBiopsia').getValue(),
                pCITBiopsiaFec:  Ext.getCmp('fecCITBiopsiaFec').getValue(),
                pCITColposcopia:  Ext.getCmp('bolCITColposcopia').getValue(),
                pCITColposcopiaFec:  Ext.getCmp('fecCITColposcopiaFec').getValue(),
                pCITAusente:  Ext.getCmp('bolCITAusente').getValue(),
                pCITSano:  Ext.getCmp('bolCITSano').getValue(),
                pCITAtrofico:  Ext.getCmp('bolCITAtrofico').getValue(),
                pCITCongestivo:  Ext.getCmp('bolCITCongestivo').getValue(),
                pCITUlcerado:  Ext.getCmp('bolCITUlcerado').getValue(),
                pCITPolipo:  Ext.getCmp('bolCITPolipo').getValue(),
                pCITMasa:  Ext.getCmp('bolCITMasa').getValue(),
                pCITObservacionesToma:  Ext.getCmp('memCITObservacionesToma').getValue(),
                pCITCalidad1:  Ext.getCmp('bolCITCalidad1').getValue(),
                pCITCalidad2:  Ext.getCmp('bolCITCalidad2').getValue(),
                pCITCalidad3:  Ext.getCmp('bolCITCalidad3').getValue(),
                pCITCalidad4:  Ext.getCmp('bolCITCalidad4').getValue(),
                pCITCausa:  Ext.getCmp('strCITCausa').getValue(),
                pCITCategorizacion1:  Ext.getCmp('bolCITCategorizacion1').getValue(),
                pCITCategorizacion2:  Ext.getCmp('bolCITCategorizacion2').getValue(),
                pCITMicroorganismos1:  Ext.getCmp('bolCITMicroorganismos1').getValue(),
                pCITMicroorganismos2:  Ext.getCmp('bolCITMicroorganismos2').getValue(),
                pCITMicroorganismos3:  Ext.getCmp('bolCITMicroorganismos3').getValue(),
                pCITMicroorganismos4:  Ext.getCmp('bolCITMicroorganismos4').getValue(),
                pCITMicroorganismos5:  Ext.getCmp('bolCITMicroorganismos5').getValue(),
                pCITMicroorganismos6:  Ext.getCmp('bolCITMicroorganismos6').getValue(),
                pCITOtrosHallazgos1:  Ext.getCmp('bolCITOtrosHallazgos1').getValue(),
                pCITOtrosHallazgos2:  Ext.getCmp('bolCITOtrosHallazgos2').getValue(),
                pCITOtrosHallazgos3:  Ext.getCmp('bolCITOtrosHallazgos3').getValue(),
                pCITOtrosHallazgos4:  Ext.getCmp('bolCITOtrosHallazgos4').getValue(),
                pCITOtrosHallazgos5:  Ext.getCmp('bolCITOtrosHallazgos5').getValue(),
                pCITOtrosHallazgos6:  Ext.getCmp('bolCITOtrosHallazgos6').getValue(),
                pCITAnormalidades1:  Ext.getCmp('bolCITAnormalidades1').getValue(),
                pCITAnormalidades2:  Ext.getCmp('bolCITAnormalidades2').getValue(),
                pCITAnormalidades3:  Ext.getCmp('bolCITAnormalidades3').getValue(),
                pCITAnormalidades4:  Ext.getCmp('bolCITAnormalidades4').getValue(),
                pCITAnormalidades5:  Ext.getCmp('bolCITAnormalidades5').getValue(),
                pCITAnormalidades6:  Ext.getCmp('bolCITAnormalidades6').getValue(),
                pCITAnormalidadesGlandulares1:  Ext.getCmp('bolCITAnormalidadesGlandulares1').getValue(),
                pCITAnormalidadesGlandulares2:  Ext.getCmp('bolCITAnormalidadesGlandulares2').getValue(),
                pCITAnormalidadesGlandulares3:  Ext.getCmp('bolCITAnormalidadesGlandulares3').getValue(),
                pCITAnormalidadesGlandulares4:  Ext.getCmp('bolCITAnormalidadesGlandulares4').getValue(),
                pCITAnormalidadesGlandulares5:  Ext.getCmp('bolCITAnormalidadesGlandulares5').getValue(),
                pCITAnormalidadesGlandulares6:  Ext.getCmp('bolCITAnormalidadesGlandulares6').getValue(),
                pCITAnormalidadesGlandulares7:  Ext.getCmp('bolCITAnormalidadesGlandulares7').getValue(),
                pCITAnormalidadesGlandulares8:  Ext.getCmp('bolCITAnormalidadesGlandulares8').getValue(),
                pCITAnormalidadesGlandulares9:  Ext.getCmp('bolCITAnormalidadesGlandulares9').getValue(),
                pCITAnormalidadesGlandulares10:  Ext.getCmp('bolCITAnormalidadesGlandulares10').getValue(),
                pCITAnormalidadesGlandulares11:  Ext.getCmp('bolCITAnormalidadesGlandulares11').getValue(),
                pCITObservacionesRes:  Ext.getCmp('memCITObservacionesRes').getValue(),
                pCITProflectura:  Ext.getCmp('strCITProflectura').getValue(),
                pCITNombreLectura:  Ext.getCmp('strCITNombreLectura').getValue(),
                pCITRegistroLectura:  Ext.getCmp('strCITRegistroLectura').getValue(),
                pCITFechaLectura:  Ext.getCmp('fecCITFechaLectura').getValue(),
                pCITProflectura2:  Ext.getCmp('strCITProflectura2').getValue(),
                pCITNombreLectura2:  Ext.getCmp('strCITNombreLectura2').getValue(),
                pCITRegistroLectura2:  Ext.getCmp('strCITRegistroLectura2').getValue(),
                pCITFechaLectura2:  Ext.getCmp('fecCITFechaLectura2').getValue(),
                pCITFechaEntregaRes:  Ext.getCmp('fecCITFechaEntregaRes').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosTomaCitologia(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar_tomacitologia',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pDiagppal: "Z124",
                pDiagrel1: null,
                pDiagrel2: null,
                pDiagrel3: null,
                pAmbito: "1",
                pFinalidadProced: "4",
                pPersonalAtiende: "3",
                pFormaActo: "1",
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pCITFecCitologia:  Ext.getCmp('fecCITFecCitologia').getValue(),
                pCITLactancia:  Ext.getCmp('strCITLactancia').getValue(),
                pCITFecUltMestruacion:  Ext.getCmp('fecCITFecUltMestruacion').getValue(),
                pCITGestaciones:  Ext.getCmp('intCITGestaciones').getValue(),
                pCITPartos:  Ext.getCmp('intCITPartos').getValue(),
                pCITAbortos:  Ext.getCmp('intCITAbortos').getValue(),
                pCITEmbarazoActual:  Ext.getCmp('strCITEmbarazoActual').getValue(),
                pCITMetodoPlanifica:  Ext.getCmp('strCITMetodoPlanifica').getValue(),
                pCITTiempoUso:  Ext.getCmp('strCITTiempoUso').getValue(),
                pCITFecUltCitologia:  Ext.getCmp('fecCITFecUltCitologia').getValue(),
                pCITResultadoCitologia:  Ext.getCmp('strCITResultadoCitologia').getValue(),
                pCITCauterizacion:  Ext.getCmp('bolCITCauterizacion').getValue(),
                pCITCauterizacionFec:  Ext.getCmp('fecCITCauterizacionFec').getValue(),
                pCITHisterectomia:  Ext.getCmp('bolCITHisterectomia').getValue(),
                pCITHisterectomiaFec:  Ext.getCmp('fecCITHisterectomiaFec').getValue(),
                pCITVaporizacion:  Ext.getCmp('bolCITVaporizacion').getValue(),
                pCITVaporizacionFec:  Ext.getCmp('fecCITVaporizacionFec').getValue(),
                pCITConizacion:  Ext.getCmp('bolCITConizacion').getValue(),
                pCITConizacionFec:  Ext.getCmp('fecCITConizacionFec').getValue(),
                pCITCrioterapia:  Ext.getCmp('bolCITCrioterapia').getValue(),
                pCITCrioterapiaFec:  Ext.getCmp('fecCITCrioterapiaFec').getValue(),
                pCITRadioterapia:  Ext.getCmp('bolCITRadioterapia').getValue(),
                pCITRadioterapiaFec:  Ext.getCmp('fecCITRadioterapiaFec').getValue(),
                pCITTtoHormonal:  Ext.getCmp('bolCITTtoHormonal').getValue(),
                pCITTtoHormonalFec:  Ext.getCmp('fecCITTtoHormonalFec').getValue(),
                pCITBiopsia:  Ext.getCmp('bolCITBiopsia').getValue(),
                pCITBiopsiaFec:  Ext.getCmp('fecCITBiopsiaFec').getValue(),
                pCITColposcopia:  Ext.getCmp('bolCITColposcopia').getValue(),
                pCITColposcopiaFec:  Ext.getCmp('fecCITColposcopiaFec').getValue(),
                pCITAusente:  Ext.getCmp('bolCITAusente').getValue(),
                pCITSano:  Ext.getCmp('bolCITSano').getValue(),
                pCITAtrofico:  Ext.getCmp('bolCITAtrofico').getValue(),
                pCITCongestivo:  Ext.getCmp('bolCITCongestivo').getValue(),
                pCITUlcerado:  Ext.getCmp('bolCITUlcerado').getValue(),
                pCITPolipo:  Ext.getCmp('bolCITPolipo').getValue(),
                pCITMasa:  Ext.getCmp('bolCITMasa').getValue(),
                pCITObservacionesToma:  Ext.getCmp('memCITObservacionesToma').getValue(),
                pCITCalidad1:  Ext.getCmp('bolCITCalidad1').getValue(),
                pCITCalidad2:  Ext.getCmp('bolCITCalidad2').getValue(),
                pCITCalidad3:  Ext.getCmp('bolCITCalidad3').getValue(),
                pCITCalidad4:  Ext.getCmp('bolCITCalidad4').getValue(),
                pCITCausa:  Ext.getCmp('strCITCausa').getValue(),
                pCITCategorizacion1:  Ext.getCmp('bolCITCategorizacion1').getValue(),
                pCITCategorizacion2:  Ext.getCmp('bolCITCategorizacion2').getValue(),
                pCITMicroorganismos1:  Ext.getCmp('bolCITMicroorganismos1').getValue(),
                pCITMicroorganismos2:  Ext.getCmp('bolCITMicroorganismos2').getValue(),
                pCITMicroorganismos3:  Ext.getCmp('bolCITMicroorganismos3').getValue(),
                pCITMicroorganismos4:  Ext.getCmp('bolCITMicroorganismos4').getValue(),
                pCITMicroorganismos5:  Ext.getCmp('bolCITMicroorganismos5').getValue(),
                pCITMicroorganismos6:  Ext.getCmp('bolCITMicroorganismos6').getValue(),
                pCITOtrosHallazgos1:  Ext.getCmp('bolCITOtrosHallazgos1').getValue(),
                pCITOtrosHallazgos2:  Ext.getCmp('bolCITOtrosHallazgos2').getValue(),
                pCITOtrosHallazgos3:  Ext.getCmp('bolCITOtrosHallazgos3').getValue(),
                pCITOtrosHallazgos4:  Ext.getCmp('bolCITOtrosHallazgos4').getValue(),
                pCITOtrosHallazgos5:  Ext.getCmp('bolCITOtrosHallazgos5').getValue(),
                pCITOtrosHallazgos6:  Ext.getCmp('bolCITOtrosHallazgos6').getValue(),
                pCITAnormalidades1:  Ext.getCmp('bolCITAnormalidades1').getValue(),
                pCITAnormalidades2:  Ext.getCmp('bolCITAnormalidades2').getValue(),
                pCITAnormalidades3:  Ext.getCmp('bolCITAnormalidades3').getValue(),
                pCITAnormalidades4:  Ext.getCmp('bolCITAnormalidades4').getValue(),
                pCITAnormalidades5:  Ext.getCmp('bolCITAnormalidades5').getValue(),
                pCITAnormalidades6:  Ext.getCmp('bolCITAnormalidades6').getValue(),
                pCITAnormalidadesGlandulares1:  Ext.getCmp('bolCITAnormalidadesGlandulares1').getValue(),
                pCITAnormalidadesGlandulares2:  Ext.getCmp('bolCITAnormalidadesGlandulares2').getValue(),
                pCITAnormalidadesGlandulares3:  Ext.getCmp('bolCITAnormalidadesGlandulares3').getValue(),
                pCITAnormalidadesGlandulares4:  Ext.getCmp('bolCITAnormalidadesGlandulares4').getValue(),
                pCITAnormalidadesGlandulares5:  Ext.getCmp('bolCITAnormalidadesGlandulares5').getValue(),
                pCITAnormalidadesGlandulares6:  Ext.getCmp('bolCITAnormalidadesGlandulares6').getValue(),
                pCITAnormalidadesGlandulares7:  Ext.getCmp('bolCITAnormalidadesGlandulares7').getValue(),
                pCITAnormalidadesGlandulares8:  Ext.getCmp('bolCITAnormalidadesGlandulares8').getValue(),
                pCITAnormalidadesGlandulares9:  Ext.getCmp('bolCITAnormalidadesGlandulares9').getValue(),
                pCITAnormalidadesGlandulares10:  Ext.getCmp('bolCITAnormalidadesGlandulares10').getValue(),
                pCITAnormalidadesGlandulares11:  Ext.getCmp('bolCITAnormalidadesGlandulares11').getValue(),
                pCITObservacionesRes:  Ext.getCmp('memCITObservacionesRes').getValue(),
                pCITProflectura:  Ext.getCmp('strCITProflectura').getValue(),
                pCITNombreLectura:  Ext.getCmp('strCITNombreLectura').getValue(),
                pCITRegistroLectura:  Ext.getCmp('strCITRegistroLectura').getValue(),
                pCITFechaLectura:  Ext.getCmp('fecCITFechaLectura').getValue(),
                pCITProflectura2:  Ext.getCmp('strCITProflectura2').getValue(),
                pCITNombreLectura2:  Ext.getCmp('strCITNombreLectura2').getValue(),
                pCITRegistroLectura2:  Ext.getCmp('strCITRegistroLectura2').getValue(),
                pCITFechaLectura2:  Ext.getCmp('fecCITFechaLectura2').getValue(),
                pCITFechaEntregaRes:  Ext.getCmp('fecCITFechaEntregaRes').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
