/*
* @category    Store Grid Toma Muestras Laboratorio Clinico
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridTomaMuestras = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridTomaMuestras.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridTomaMuestras',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/transcribirlabo/controlador_tomamuestras.php',
                method: 'POST'
            }),
            baseParams: {
                task: "LISTAR_TOMA"
            },
            autoLoad: true,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'FechaEstudio' },
                { name: 'CAS' },
                { name: 'TipDoc' },
                { name: 'Documento' },
                { name: 'nomPaciente' },
                { name: 'FecNac' },
                { name: 'Edad' },
                { name: 'NAP' },
                { name: 'FecNAP' },
                { name: 'NAP_obs' },
                { name: 'NADEF' },
                { name: 'FecNADEF' },
                { name: 'NADEF_obs' },
                { name: 'GrupoLaboratorio' },
                { name: 'Examen' },
                { name: 'Turno' },
                { name: 'Estrategia' },
                { name: 'itemsExamen' }
            ])
        }, cfg));
    }
});
new StoreGridTomaMuestras();