/*
* @category    Store Seleccion Fechas para Programar Agenda
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreSeleccionFechasAgenda = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreSeleccionProcedimientos.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreSeleccionFechasAgenda',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/profesionales/controlador_profesionales.php',
                method: 'POST'
            }),
            baseParams:{task: "ESTABLECER_FECHAS_PROGRAMAR"},
            autoLoad: false,
            loadMask: true,
            reader: new Ext.data.JsonReader({
                root: 'results'
            },
            [
                {
                    name: 'FechaAgendar'
                },
                {
                    name: 'DiaSemana'
                },
                {
                    name: 'Seleccionar',
                    type: 'bool'
                }
            ])
        }, cfg));
    }
});
new StoreSeleccionFechasAgenda();

