/*
* @category    Store Profesionales x Sedes x IPS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridProfesionalesxSEDExIPS = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridProfesionalesxSEDExIPS.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridProfesionalesxSEDExIPS',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/profesionales/controlador_profesionales.php',
                method: 'POST'
            }),
            baseParams:{task: "GRID_SEDE_IPS"},
            autoload: false,
            groupField: 'sede',
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {
                    name: 'prestador'
                },
                {
                    name: 'profesional'
                },
                {
                    name: 'idsede'
                },
                {
                    name: 'sede'
                },
                {
                    name: 'idips'
                },
                {
                    name: 'ips'
                },
            ]),
            sortInfo:{field: 'sede', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridProfesionalesxSEDExIPS();

