/*
* @category    Store Profesionales x Consultorios x IPS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridConsultoriosxProfesional = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridConsultoriosxProfesional.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridConsultoriosxProfesional',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/profesionales/controlador_profesionales.php',
                method: 'POST'
            }),
            baseParams:{
                task: "GRID_CONSULTORIOS_IPS"
            },
            autoload: false,
                reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {
                    name: 'idProfesional'
                },
                {
                    name: 'idIPS'
                },
                {
                    name: 'idConsultorio'
                },
                {
                    name: 'Consultorio'
                },
            ]),
            sortInfo:{field: 'Consultorio', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridConsultoriosxProfesional();

