/*
* @category    Store Plantilla Procedimientos x Profesionales 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridProfesionalesPlantillaProced = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridProfesionalesPlantillaProced.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridProfesionalesPlantillaProced',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/profesionales/controlador_profesionales.php',
                method: 'POST'
            }),
            baseParams:{task: "GRID_PLANTILLA_PROCED"},
            autoload: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {
                    name: 'idPlantillaProcedxProfe'  
                },
                {
                    name: 'idProfesional'
                },
                {
                    name: 'IdProced'
                },
                {
                    name: 'nomPlantilla'
                },
                {
                    name: 'CodProced'
                },
                {
                    name: 'CUPSCodigo'
                },
                {
                    name: 'DesProced'
                },
                {
                    name: 'formatoPlantilla'
                },
                {
                    name: 'Usuario'
                },
                {
                    name: 'FechaAct'
                }
            ]),
            sortInfo:{field: 'nomPlantilla', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridProfesionalesPlantillaProced();

