/*
* @category    Store Horario x Plantilla Citas x Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridProfesionalesPlantillaCitasHorario = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridProfesionalesPlantillaCitasHorario.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridProfesionalesPlantillaCitasHorario',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/profesionales/controlador_profesionales.php',
                method: 'POST'
            }),
            baseParams:{task: "GRID_PLANTILLA_CITAS_HORARIO"},
            autoload: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {
                    name: 'idPlantilla'
                },
                {
                    name: 'idTipoHorario'
                },
                {
                    name: 'GrupoPrioritario'
                },
                {
                    name: 'AsignarWeb'
                },
                {
                    name: 'IdCita'
                },
                {
                    name: 'DesCita'
                },
                {
                    name: 'InfoAddCita'
                },
                {
                    name: 'DesImprime'
                },
                {
                    name: 'HoraAtencion'
                },
                {
                    name: 'Activo'
                },
                {
                    name: 'Usuario'
                },
                {
                    name: 'FechaAct'
                }
            ]),
            sortInfo:{field: 'IdCita', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridProfesionalesPlantillaCitasHorario();

