/*
* @category    Store Plantilla Citas x Profesionales 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridProfesionalesPlantillaCitas = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridProfesionalesPlantillaCitas.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridProfesionalesPlantillaCitas',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/profesionales/controlador_profesionales.php',
                method: 'POST'
            }),
            baseParams:{task: "GRID_PLANTILLA_CITAS"},
            autoload: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {
                    name: 'idPestador'
                },
                {
                    name: 'idProfesional'
                },
                {
                    name: 'idPlantilla'
                },
                {
                    name: 'Descripcion'
                },
                {
                    name: 'Activo'
                },
                {
                    name: 'Usuario'
                },
                {
                    name: 'FechaAct'
                }
            ]),
            sortInfo:{field: 'Descripcion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridProfesionalesPlantillaCitas();

