/*
* @category    Store Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridProfesionales = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridProfesionales.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridProfesionales',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/profesionales/controlador_profesionales.php',
                method: 'POST'
            }),
            autoLoad: false,
            baseParams:{task: "LISTAROFIMEDICAL"},
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IDRecord', type: 'int', mapping: 'idrecord'},
                {name: 'DocumentoID', type: 'int', mapping: 'documento'},
                {name: 'Descripcion', type: 'string', mapping: 'descripcion'},
                {name: 'Especialidad', type: 'string', mapping: 'nomespecialidad'},
                {name: 'Registro', type: 'string', mapping: 'registro'},
                {name: 'Direccion', type: 'string', mapping: 'direccion'},
                {name: 'Telefono', type: 'string', mapping: 'telefono'},
                {name: 'Email', type: 'string', mapping: 'email'},
                {name: 'TipoProfe', type: 'string', mapping: 'nomtipoprofe'},
                {name: 'ProgramarAgenda', type: 'string', mapping: 'programar'},
                {name: 'ModificarKardex', type: 'string', mapping: 'modificar'},
                {name: 'VlrMulta', type: 'string', mapping: 'vlrmulta'},
                {name: 'Activo', type: 'string', mapping: 'activo'},
                {name: 'IdEsp', type: 'string', mapping: 'especialidad'},
                {name: 'IdTipo', type: 'string', mapping: 'tipoprofe'},
                {name: 'Usuario'},
                {name: 'FechaAct'}
            ]),
            sortInfo:{field: 'IDRecord', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridProfesionales();

