/*
* @category    Store Agendas Programadas x Profesionales 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridProfesionalesAgendasProgramadas = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridProfesionalesAgendasProgramadas.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridProfesionalesAgendasProgramadas',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/profesionales/controlador_profesionales.php',
                method: 'POST'
            }),
            baseParams:{task: "GRID_AGENDA_PROGRAMADAS"},
            autoLoad: false,
            groupField: 'Consultorio',
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {
                    name: 'idAgenda'
                },
                {
                    name: 'idProfesional'
                },
                {
                    name: 'idIPS'
                },
                {
                    name: 'idConsultorio'
                },
                {
                    name: 'idPlantilla'
                },
                {
                    name: 'fecAgenda',
                    type: 'string'
                },
                {
                    name: 'Consultorio'
                },
                {
                    name: 'Plantilla'
                },
                {
                    name: 'estado'
                },
                {
                    name: 'UsuarioAnula'
                },
                {
                    name: 'UsuarioQuienAnula'
                },
                {
                    name: 'FechaAnula'
                },
                {
                    name: 'MotivoAnula'
                },
                {
                    name: 'Usuario'
                },
                {
                    name: 'FechaAct'
                }
            ])
            //sortInfo:{field: 'fecAgenda', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridProfesionalesAgendasProgramadas();

