/*
* @category    Store Profesionales Agenda Manual
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreProfesionalesAgendaManual = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreProfesionalesAgendaManual.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreProfesionalesAgendaManual',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/profesionales/controlador_profesionales.php',
                method: 'POST'
            }),
            baseParams:{task: "AGENDA_MANUAL_LISTAR"},
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'IdAgendaManual' },
                { name: 'Prestador' },
                { name: 'IPS' },
                { name: 'Profesional' },
                { name: 'FecCita' },
                { name: 'codCita' },
                { name: 'OrdenCita' },
                { name: 'HoraCita' },
                { name: 'HoraCitaInfAdd' },
                { name: 'Paciente' },
                { name: 'Cliente' },
                { name: 'IdProced' },
                { name: 'Observaciones' },
                { name: 'EstadoReg' },
                { name: 'ObservacionesEstado' },
                { name: 'CAS' },
                { name: 'Usuario' },
                { name: 'FechaAct' },
                { name: 'TipDoc' },
                { name: 'Documento' },
                { name: 'PrimerApellido' },
                { name: 'SegundoApellido' },
                { name: 'PrimerNombre' },
                { name: 'SegundoNombre' },
                { name: 'FecNac' },
                { name: 'Edad' },
                { name: 'Genero' },
                { name: 'Direccion' },
                { name: 'Telefono' },
                { name: 'Telefono1' },
                { name: 'Email' },
                { name: 'DeptoMunici' },
                { name: 'CodProced' },
                { name: 'DesProced' },
                { name: 'Cliente' },
                { name: 'EstadoCon' },
            ]),
            sortInfo:{field: 'OrdenCita', direction: "ASC"}
        }, cfg));
    }
});
new StoreProfesionalesAgendaManual();

