/*
* @category    Store Procedimientos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreSeleccionProcedimientos = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreSeleccionProcedimientos.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreSeleccionProcedimientos',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/procedimientos/gridseleccionprocedimientos.php',
                method: 'POST'
            }),
            autoload: false,
            reader: new Ext.data.JsonReader({
                root: 'results'
            },
            [
                {
                    name: 'IdProced'
                },
                {
                    name: 'Descripcion'
                },
                {
                    name: 'CodProced'
                },
                {
                    name: 'DesProced'
                },
                {
                    name: 'CUPSCodigo'
                },
                {
                    name: 'Seleccionar',
                    type: 'bool'
                }
            ]),
            sortInfo:{field: 'Descripcion', direction: "ASC"}
        }, cfg));
    }
});
new StoreSeleccionProcedimientos();

