/*
* @category    Store Record Conceptos Registro Venta
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

var DTSConceptosRegistroVenta = Ext.extend(Ext.data.JsonStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        DTSConceptosRegistroVenta.superclass.constructor.call(this, Ext.apply({
            storeId: 'DTSConceptosRegistroVenta',
            idProperty: 'IDReg',
            root: 'rows',
            //url: 'js_proxy',
            url: '../../controlador/posoptica/gridconceptosventa.php',
            method: 'POST',
            fields: [
                {name: 'IDReg', type: 'int'},
                {name: 'idConceptoItem', type: 'int'},
                {name: 'UsaLoteItem', type: 'int'},
                {name: 'KardexItem', type: 'int'},
                {name: 'TituloItem', type: 'string'},
                {name: 'CodConceptoItem', type: 'string'},
                {name: 'DesConceptoItem', type: 'string'},
                {name: 'LoteConceptoItem', type: 'int'},
                {name: 'DesLoteConceptoItem', type: 'string'},
                {name: 'VlrTarifaItem', type: 'decimal'},
                {name: 'PorIVAItem', type: 'int'},
                {name: 'VlrIVAItem', type: 'decimal'},
                {name: 'CantidadItem', type: 'int'},
                {name: 'VlrTotalItem', type: 'decimal'},
                {name: 'VlrCuotaModeradoraItem', type: 'decimal'},
                {name: 'VlrCopagoItem', type: 'decimal'},
                {name: 'VlrDescuentosItem', type: 'decimal'},
                {name: 'VlrEmpresaItem', type: 'decimal'},
                {name: 'VlrNetoItem', type: 'decimal'},
                {name: 'EntregadoItem', type: 'string'},
                {name: 'REFRACTIVO_RxOD_Esf', type: 'string'},
                {name: 'REFRACTIVO_RxOD_Cil', type: 'string'},
                {name: 'REFRACTIVO_RxOD_Eje', type: 'string'},
                {name: 'REFRACTIVO_RxOD_Add', type: 'string'},
                {name: 'REFRACTIVO_RxOD_AVFL', type: 'string'},
                {name: 'REFRACTIVO_RxOD_AVFP', type: 'string'},
                {name: 'REFRACTIVO_RxOI_Esf', type: 'string'},
                {name: 'REFRACTIVO_RxOI_Cil', type: 'string'},
                {name: 'REFRACTIVO_RxOI_Eje', type: 'string'},
                {name: 'REFRACTIVO_RxOI_Add', type: 'string'},
                {name: 'REFRACTIVO_RxOI_AVFL', type: 'string'},
                {name: 'REFRACTIVO_RxOI_AVFP', type: 'string'},
                {name: 'COLOR_TTO', type: 'string'},
                {name: 'COLOR_TTO_DESCRIPCION', type: 'string'},
                {name: 'MONTURA', type: 'string'},
                {name: 'MONTURA_H', type: 'string'},
                {name: 'MONTURA_V', type: 'string'},
                {name: 'MONTURA_D', type: 'string'},
                {name: 'MONTURA_P', type: 'string'},
                {name: 'MONTURA_NP_OD', type: 'string'},
                {name: 'MONTURA_NP_OI', type: 'string'},
                {name: 'LABORATORIO_OBS', type: 'string'}
             ],
             sortInfo: {
                 field: 'DesConceptoItem',
                 direction: 'ASC' // or 'DESC' (case sensitive for local sorting)
            }
        }, cfg));
    }
});
new DTSConceptosRegistroVenta();
