/*
* @category    Store Grid Kardex Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridKardexPacientes = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridKardexPacientes.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridKardexPacientes',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/pacientes/controlador_pacientes_kardex.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR"},
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdKardex'},
                {name: 'ProgramaNom'},
                {name: 'FechaIngreso'},
                {name: 'ViaIngreso'},
                {name: 'Estado'},
                {name: 'FechaRetiro'},
                {name: 'MotivoRetiro'}
            ]),
            sortInfo:{field: 'FechaIngreso', direction: "DESC"}
        }, cfg));
    }
});
new StoreGridKardexPacientes();

