/*
* @category    Store Odontograma Detalle
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridEditOdontogramaHC = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridEditOdontogramaHC.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridEditOdontogramaHC',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/odontograma/controlador_odontograma.php',
                method: 'POST'
            }),
            baseParams: {
                task: "LOAD_DETALLEODONTOGRAMA"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'IdOdontogramaDetalle', type: 'number'},
                { name: 'Orden', type: 'number'},
                { name: 'IdConsecutivoOdontograma' },
                { name: 'Diente' },
                { name: 'Diagnostico' },
                { name: 'Afecta' },
                { name: 'Superficies' },
                { name: 'descDiagnostico' }
            ]),
            sortInfo:{field: 'Orden', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridEditOdontogramaHC();

