/*
* @category    Store Grid Solicitudes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

var StoreGridSolicitudNOPOS = Ext.extend(Ext.data.JsonStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridSolicitudNOPOS.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridSolicitudNOPOS',
            idProperty: 'IDReg',
            root: 'results',
            url: '../../controlador/nopos/controlador_nopos.php',
            method: 'POST',
            fields: [
                { name:'idConsecutivoSolicitud' },
                { name:'Ambito' },
                { name:'Descripcion' },
                { name:'Empresa' },
                { name:'IPS' },
                { name:'Profesional' },
                { name:'nomProfesional' },
                { name:'Paciente' },
                { name:'Cliente' },
                { name:'CAS' },
                { name:'FecSolicitud' },
                { name:'ResumenDx' },
                { name:'CodDiagnostico' },
                { name:'DescripcionCasoClinico' },
                { name:'TratamientosRealizados' },
                { name:'AyudasDiagnosticas' },
                { name:'Otros' }
             ],
             sortInfo: {
                 field: 'FecSolicitud',
                 direction: 'DESC'
            }
        }, cfg));
    }
});
new StoreGridSolicitudNOPOS();
