/*
* @category    Store Manual Tarifario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridManualTarifario = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridManualTarifario.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridManualTarifario',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/manualtarifario/controlador_manualtarifario.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR"},
            autoload: false,
            reader: new Ext.data.JsonReader({
                root: 'results'
            },
            [
                { name: 'IdManualTarifario' },
                { name: 'Descripcion' },
                { name: 'Usuario' },
                { name: 'FechaAct' },
                { name: 'Activo' }
            ]),
            sortInfo:{field: 'Descripcion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridManualTarifario();
