/*
* @category    Store Conceptos x Manual Tarifario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridConceptosxManual = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridConceptosxManual.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridConceptosxManual',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/manualtarifario/controlador_manualtarifario.php',
                method: 'POST'
            }),
            baseParams:{
                task: "LISTAR_CONCEPTOSxMANUAL",
                start: 0, 
                limit: 15
            },
            autoload: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'IdManualTarifario' },
                { name: 'IdProcedimiento' },
                { name: 'VlrTarifa' },
                { name: 'Usuario' },
                { name: 'FechaAct' },
                { name: 'CodProced' },
                { name: 'DesProced' }
            ]),
            sortInfo:{field: 'CodProced', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridConceptosxManual();
