/*
* @category    Store Incentario Movimientos x Conceptos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridMovimientoxConceptos = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridMovimientoxConceptos.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridMovimientoxConceptos',
            autoLoad: false,
            baseParams:{task: "GRID_MOVIMIENTO_CONCEPTO"},
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/inventario/controlador_inventario.php',
                method: 'POST'
            }),
            groupField: 'IdGrupo',
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name:'IdConsecutivoKardex' },
                { name:'FecMovimiento' },
                { name:'DescConcepto' },
                { name:'Inicial', type: "int" },
                { name:'SaldoAnt', type: "int" },
                { name:'SaldoIniAnt', type: "int" },
                { name:'Entradas', type: "int" },
                { name:'Salidas', type: "int" },
                { name:'Saldo', type: "int" },
                { name:'Bodega' },
                { name:'Zona' },
                { name:'Lote' },
                { name:'IdGrupo' }
            ])
        }, cfg));
    }
});
new StoreGridMovimientoxConceptos();

