/*
* @category    Store Consultorios x Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridConsultorios = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridConsultorios.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridConsultorios',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/consultorios/controlador_consultorios.php',
                method: 'POST'
            }),
            baseParams:{task: "GRID_CONSULTORIOS"},
            autoload: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {
                    name: 'Codigo'
                },
                {
                    name: 'Descripcion'
                },
                {
                    name: 'Usuario'
                },
                {
                    name: 'FechaAct'
                }
            ])
        }, cfg));
    }
});
new StoreGridConsultorios();

