/*
* @category    Store Archivos Anexos Conceptos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreArchivosAnexosConceptos = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreArchivosAnexosConceptos.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreArchivosAnexosConceptos',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/conceptos/controlador_conceptos.php',
                method: 'POST'
            }),
            autoLoad: true,
            baseParams:{task: "LISTAR_ARCHIVOS_ANEXOS"},
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name:'Descripcion' }
            ]),
            sortInfo:{field: 'Descripcion', direction: "ASC"}
        }, cfg));
    }
});
new StoreArchivosAnexosConceptos();

