/*
* @category    Store Plantilla Citas x Profesional
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StorePlantillaCitasxProfe = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StorePlantillaCitasxProfe.superclass.constructor.call(this, Ext.apply({
            storeId: 'StorePlantillaCitasxProfe',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/combobox/cbplantillacitasxprofe.php',
                method: 'POST'
            }),
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'rows'
            },
            [
                {
                    name: 'Codigo'
                },
                {
                    name: 'Descripcion'
                }
            ]),
            sortInfo:{field: 'Descripcion', direction: "ASC"}
        }, cfg));
    }
});
new StorePlantillaCitasxProfe();

