/*
* @category    Store Procesos x Pacientes HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridProcesosClinicaCaidas = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridProcesosClinicaCaidas.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridProcesosClinicaCaidas',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/clinicacaidas/controlador_clinicacaidas.php',
                method: 'POST'
            }),
            groupField: 'UbicacionActual',
            baseParams: {
                task: "VerProcesos"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'Prestador' },
                { name: 'IPS' },
                { name: 'Paciente' },
                { name: 'NomPaciente' },
                { name: 'CAS' },
                { name: 'ConsecutivoDetalle' },
                { name: 'ConsecutivoHC' },
                { name: 'FechaAtencion' },
                { name: 'ProcesoActual' },
                { name: 'UbicacionActual' },
                { name: 'ConceptoFinal' },
                { name: 'PasoEnfermeria' },
                { name: 'PasoMedicina' },
                { name: 'PasoTerapiaFisica' },
                { name: 'PasoTrabajoSocial' },
                { name: 'TipDoc' },
                { name: 'Documento' },
                { name: 'PrimerApellido' },
                { name: 'SegundoApellido' },
                { name: 'PrimerNombre' },
                { name: 'SegundoNombre' },
                { name: 'GeneroPaciente' },
                { name: 'PasoActual' }
            ]),
            sortInfo:{field: 'FechaAtencion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridProcesosClinicaCaidas();

