/*
* @category    Store Tarifas x Clientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridTarifasClientes = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridTarifasClientes.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridTarifasClientes',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/clientes/controlador_clientes.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR_GRID_TARIFAS"},
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdRegistroTarifa'},
                {name: 'IdPrestador'},
                {name: 'IdCliente'},
                {name: 'IdPlan'},
                {name: 'Plan'},
                {name: 'IdSubPlan'},
                {name: 'SubPlan'},
                {name: 'IdTipoEstudio'},
                {name: 'TipoEstudio'},
                {name: 'IdManualTarifario'},
                {name: 'ManualTarifario'},
                {name: 'DescripcionProcedimiento'},
                {name: 'VlrTarifa'},
                {name: 'Ajuste'},
                {name: 'Activo'}
            ])
        }, cfg));
    }
});
new StoreGridTarifasClientes();

