/*
* @category    Store Tarifas x Clientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridMatrizAutorizaciones = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridMatrizAutorizaciones.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridMatrizAutorizaciones',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/clientes/controlador_clientes.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR_GRID_MATRIZ_AUTORIZACIONES"},
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdCliente'},
                {name: 'IdProcedimiento'},
                {name: 'CodProced'},
                {name: 'DesProced'},
                {name: 'NivelAuditoria'},
                {name: 'Nivel'},
                {name: 'CantidadMaxSol'},
                {name: 'MinDiasSol'}
            ])
        }, cfg));
    }
});
new StoreGridMatrizAutorizaciones();

