/*
* @category    Store Contrato x Clientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridContratosClientes = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridContratosClientes.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridContratosClientes',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/clientes/controlador_clientes2013.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR_GRID_CONTRATOS"},
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdContrato'},
                {name: 'IdCliente'},
                {name: 'NroContrato'},
                {name: 'Descripcion'},
                {name: 'FecDesde'},
                {name: 'FecHasta'},
                {name: 'VlrTotal'},
                {name: 'VlrAlerta'},
                {name: 'DiasVenceFac'},
                {name: 'AsignarCita'},
                {name: 'Activo'},
                {name: 'CodRapido'}
            ]),
            sortInfo:{field: 'Descripcion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridContratosClientes();

