/*
* @category    Store Clientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridClientes = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridClientes.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridClientes',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/clientes/controlador_clientes2013.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR"},
            groupField: 'DescTipo',
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdCliente'},
                {name: 'Prestador'},
                {name: 'Codigo'},
                {name: 'Clase'},
                {name: 'Tipo'},
                {name: 'DescTipo'},
                {name: 'Tdoc'},
                {name: 'Documento'},
                {name: 'Digitover'},
                {name: 'Descripcion'},
                {name: 'DescripcionFac'},
                {name: 'Direccion'},
                {name: 'Telefono'},
                {name: 'Email'},
                {name: 'CodigoSUPERSALUD'},
                {name: 'TipoAfiliado'},
                {name: 'FacturarPaciente'},
                {name: 'FacturarParticular'},
                {name: 'RecaudoAutomaticoParticulares'},
                {name: 'FacturarCopagos'},
                {name: 'UsaListadoAtencion'},
                {name: 'UsaMultas'},
                {name: 'UsaAuditoria'},
                {name: 'AtenderFueraListado'},
                {name: 'RequiereAutorizacion'},
                {name: 'RecaudoMedicamentos'},
                {name: 'RecaudoRemisiones'},
                {name: 'RecaudoOrdenamientos'},
                {name: 'CopagoDigitado'},
                {name: 'CodigoOfiClinicOld'},
                {name: 'Activo'},
                {name: 'Usuario'},
                {name: 'FechaAct'},
                {name: 'CodRapido'}
            ]),
            sortInfo:{field: 'DescTipo', direction: "ASC", field: 'Descripcion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridClientes();

