/*
* @category    Store Grid Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridProfesionalesCitas = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridProfesionalesCitas.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridProfesionalesCitas',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/agendas/controlador_asignarcitas201601.php',
                method: 'POST'
            }),
            autoLoad: false,
            baseParams:{task: "LISTAR_PROFESIONALES_AGENDA"},
            //groupField: 'especialidadDescripcion',
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'especialidadDescripcion'},
                {name: 'profesionalID'},
                {name: 'profesionalDescripcion'},
                {name: 'idConsultorio'},
                {name: 'Ubicacion'},
                {name: 'agendaID'},
                {name: 'Disponibles'}
            ]),
            sortInfo:{field: 'profesionalDescripcion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridProfesionalesCitas();

