/*
* @category    Store Grid Horarios Disponibles x Agenda
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridHoarariosxAgendaDisponiblesCitas = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridHoarariosxAgendaDisponiblesCitas.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridHoarariosxAgendaDisponiblesCitas',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/agendas/controlador_asignarcitas.php',
                method: 'POST'
            }),
            autoLoad: false,
            baseParams:{task: "LISTAR_HORARIOS_AGENDAS_DISPONIBLES"},
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {
                    name: 'citaID'
                },
                {
                    name: 'IdCita'
                },
                {
                    name: 'citaDescripcion'
                },
                {
                    name: 'citaObservacionesPlantilla'
                },
                {
                    name: 'GrupoPrioritario',
                    type: 'bool'
                },
                {
                    name: 'AsignarWeb',
                    type: 'bool'
                },
                {
                    name: 'Seleccionar',
                    type: 'bool'
                },
                {
                    name: 'citaInfoAdd',
                    type: 'string'
                },
                {
                    name: 'TipoHorario'
                },
                {
                    name: 'Estado'
                },
                {
                    name: 'GrupoCita'
                },
                {
                    name: 'MostrarGrupoCita'
                }
            ]),
            sortInfo:{field: 'IdCita', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridHoarariosxAgendaDisponiblesCitas();

