/*
* @category    Store Grid Dias Agendas Disponibles
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridDiasDispCitas = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridDiasDispCitas.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridDiasDispCitas',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/agendas/controlador_asignarcitasbas201702.php',
                method: 'POST'
            }),
            autoLoad: false,
            baseParams:{task: "LISTAR_AGENDAS_DIASDISPONIBLES"},
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'agendaFecha'},
                {name: 'Disponibles'}
            ]),
            sortInfo:{field: 'agendaFecha', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridDiasDispCitas();

