/*
* @category    Store Grid Citas x Legalizar
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridCitasxLegalizar = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridCitasxLegalizar.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridCitasxLegalizar',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/agendas/controlador_asignarcitas.php',
                method: 'POST'
            }),
            autoLoad: false,
            baseParams:{task: "LISTAR_CITASxLEGALIZAR"},
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'Prestador'},
                {name: 'Sede'},
                {name: 'IPS'},
                {name: 'Paciente'},
                {name: 'CAS'},
                {name: 'MarcaExenta'},
                {name: 'Profesional'},
                {name: 'FechaCita'},
                {name: 'Cliente'},
                {name: 'Ubicacion'},
                {name: 'Actividad'},
                {name: 'Agendado'},
                {name: 'YaLegalizado'},
                {name: 'HoraAgenda'},
                {name: 'HoraAtencion'}
            ])
        }, cfg));
    }
});
new StoreGridCitasxLegalizar();

