/*
* @category    Store Control de Signos Vitales Hospitalario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridVacunacion = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridVacunacion.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridVacunacion',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/evolucionhc2014.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VACUNACION_LISTAR"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'Consecutivo' },
                { name: 'CASRef' },
                { name: 'Paciente' },
                { name: 'Edad_Anios' },
                { name: 'Edad_Meses' },
                { name: 'Edad_Dias' },
                { name: 'FechaAplicacion', type: 'date', dateFormat: 'Y-m-d'},
                { name: 'IdProcedimiento' },
                { name: 'Dosis' },
                { name: 'PrestadorVacuna' },
                { name: 'Observacion' },
                { name: 'Biologico' }
            ]),
            sortInfo:{field: 'FechaAplicacion', direction: "DESC"}
        }, cfg));
    }
});
new StoreGridVacunacion();

