/*
* @category    Store Procesos Partisalud
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridProcesosPartisalud = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridProcesosPartisalud.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridProcesosPartisalud',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/partisalud.php',
                method: 'POST'
            }),
            groupField: 'UbicacionActual',
            baseParams: {
                task: "VerProcesosSinTerminar"
            },
            autoLoad: true,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'Paciente' },
                { name: 'NomPaciente' },
                { name: 'TipDoc' },
                { name: 'Documento' },
                { name: 'PrimerApellido' },
                { name: 'SegundoApellido' },
                { name: 'PrimerNombre' },
                { name: 'SegundoNombre' },
                { name: 'GeneroPaciente' },
                { name: 'CAS' },
                { name: 'ConsecutivoDetalle' },
                { name: 'ConsecutivoHC' },
                { name: 'FechaAtencion' },
                { name: 'Actividad' },
                { name: 'IdCliente' },
                { name: 'Cliente' },
                { name: 'TipoExamen' },
                { name: 'ProcesoActual' },
                { name: 'UbicacionActual' },
                { name: 'PasoTomaSignos' },
                { name: 'ConceptoTomaSignos' },
                { name: 'PasoLaboratorio' },
                { name: 'ConceptoLaboratorio' },
                { name: 'PasoFonoaudiologia' },
                { name: 'ConceptoFonoaudiologia' },
                { name: 'PasoMedicoOcupacional' },
                { name: 'ConceptoMedicoOcupacional' },
                { name: 'PasoActual' },
                { name: 'ConceptoFinal' },
                { name: 'idProfesional' },
                { name: 'NomProfesional' },
                { name: 'NroAutorizacion' },
                { name: 'TomaMuestras'}
            ])
            //sortInfo:{field: 'FechaAtencion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridProcesosPartisalud();

