/*
* @category    Store Pacientes Observacion Hospitalizacion
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridObservaHospitaliza = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridObservaHospitaliza.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridObservaHospitaliza',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/evolucionhc2013.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VER_PACIENTES_OBSERVACION_HOSPITALIZA"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'CAS' },
                { name: 'Tipo' },
                { name: 'FechaIngreso' },
                { name: 'HoraIngreso' },
                { name: 'ProfesionalIngreso' },
                { name: 'NroAutorizacion' },
                { name: 'CausaExterna' },
                { name: 'DiagnosticoSalida' },
                { name: 'DiagnosticoSalidaRel1' },
                { name: 'DiagnosticoSalidaRel2' },
                { name: 'DiagnosticoSalidaRel3' },
                { name: 'DestinoSalida' },
                { name: 'EstadoSalida' },
                { name: 'CausaMuerte' },
                { name: 'FechaSalida' },
                { name: 'HoraSalida' },
                { name: 'ProfesionalSalida' },
                { name: 'NroHabitacion' },
                { name: 'NroCama' },
                { name: 'EstadoReg' },
                { name: 'Usuario' },
                { name: 'FechaAct' },
                { name: 'Paciente' },
                { name: 'TipDoc' },
                { name: 'Documento' },
                { name: 'PrimerApellido' },
                { name: 'SegundoApellido' },
                { name: 'PrimerNombre' },
                { name: 'SegundoNombre' },
                { name: 'FecNac' },
                { name: 'Edad' },
                { name: 'Genero' },
                { name: 'Cliente' },
                { name: 'Plan' },
                { name: 'Subplan' },
                { name: 'nomCliente' }
            ])
        }, cfg));
    }
});
new StoreGridObservaHospitaliza();

