/*
* @category    Store Dientes Actividaees Realizadas x Pacientes HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridNecesidadesAtencionTratamiento = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridNecesidadesAtencionTratamiento.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridNecesidadesAtencionTratamiento',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/controlador_odontologia.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerNecesidadesAtencionTratamiento"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'IdConsecutivoDientesTratamiento' },
                { name: 'IdConsecutivoNecesidad' },
                { name: 'CodProced' },
                { name: 'DesProced' },
                { name: 'Diente' },
                { name: 'Superficie' },
                { name: 'Paciente' },
                { name: 'IdProced' },
                { name: 'Estado' },
                { name: 'Programa' },
                { name: 'Prioridad' },
                { name: 'VlrActividad' },
                { name: 'VlrCopago' },
                { name: 'VlrCopago' },
                { name: 'EstadoRegistro' }
            ]),
            sortInfo:{field: 'IdConsecutivoDientesTratamiento', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridNecesidadesAtencionTratamiento();

