/*
* @category    Store Ingresos Egresos Hogar Paso Pacientes HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridEvolucionesxPacienteOfimedical = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridEvolucionesxPacienteOfimedical.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridEvolucionesxPacienteOfimedical',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/hogardepaso.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerIngresosEgresos"
            },
            autoLoad: true,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'Paciente' },
                { name: 'Origen' },
                { name: 'ID_INGRESO' },
                { name: 'FECHA_INGRESO', type: 'date', dateFormat: 'd/m/Y'},
                { name: 'FecIngreso', type: 'string' },
                { name: 'HORA_INGRESO' },
                { name: 'newHORA_INGRESO' },
                { name: 'ENTIDAD_REMITE' },
                { name: 'SERVICIO_REMITE' },
                { name: 'EPSARS' },
                { name: 'DIAGNOSTICO' },
                { name: 'INGRESO_HOGAR' },
                { name: 'HABITACION' },
                { name: 'CAMA' },
                { name: 'NOM_HABITACION' },
                { name: 'NOM_CAMA' },
                { name: 'ALIMENTO_DESAYUNO' },
                { name: 'ALIMENTO_ALMUERZO' },
                { name: 'ALIMENTO_COMIDA' },
                { name: 'TDOC_ACOMPANANTE' },
                { name: 'DOCUMENTO_ACOMPANANTE' },
                { name: 'NOMBRE_ACOMPANANTE' },
                { name: 'GENERO_ACOMPANANTE' },
                { name: 'TELEFONO_ACOMPANANTE' },
                { name: 'PARENTESCO_ACOMPANANTE' },
                { name: 'INGRESO_HOGAR_ACOMPANANTE' },
                { name: 'ALIMENTO_DESAYUNO_ACOMPANANTE' },
                { name: 'ALIMENTO_ALMUERZO_ACOMPANANTE' },
                { name: 'ALIMENTO_COMIDA_ACOMPANANTE' },
                { name: 'ACTIVO' },
                { name: 'FECHA_EGRESO', type: 'string'},
                { name: 'HORA_EGRESO' },
                { name: 'OBSRVACION_EGRESO' },
                { name: 'ALERTA' },
                { name: 'USUARIO_EGRESO' }
            ]),
            sortInfo:{field: 'FECHA_INGRESO', direction: "DESC", field: 'ID_INGRESO', direction: "DESC"}
        }, cfg));
    }
});
new StoreGridEvolucionesxPacienteOfimedical();

