/*
* @category    Store Grid Consultas por Confirmar
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridHistorialMedicamentos = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridHistorialMedicamentos.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridHistorialMedicamentos',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/evolucionhc.php',
                method: 'POST'
            }),
            baseParams:{task: "VerHistorialMedicamentosxPaciente"},
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'FechaAtencion'},
                {name: 'DxPpal'},
                {name: 'DescripcionDx'},
                {name: 'Medicamento'},
                {name: 'Cantidad'},
                {name: 'Posologia'}
            ]),
            sortInfo:{field: 'FechaAtencion', direction: "DESC"}
        }, cfg));
    }
});
new StoreGridHistorialMedicamentos();

