/*
* @category    Store Historial Ordenamientos HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridHistorialOrdenamientosHC = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridHistorialOrdenamientosHC.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridHistorialOrdenamientosHC',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/evolucionhc.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerHistorialOrdenamientosxPaciente"
            },
            autoLoad: true,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'Prestador'},
                {name: 'Sede'},
                {name: 'IPS'},
                {name: 'Paciente'},
                {name: 'CAS'},
                {name: 'idCliente'},
                {name: 'idPlan'},
                {name: 'idSubPlan'},
                {name: 'idContrato'},
                {name: 'FechaCita'},
                {name: 'Cliente'},
                {name: 'Plan'},
                {name: 'SubPlan'},
                {name: 'Contrato'},
                {name: 'ConsecutivoDetalle'},
                {name: 'IdProcedimiento'},
                {name: 'CodProcedimiento'},
                {name: 'Actividad'},
                {name: 'IdPrograma'},
                {name: 'Programa'},
                {name: 'ConsecutivoHC'},
                {name: 'FechaAtencion'},
                {name: 'NomProfe'},
                {name: 'Profesional'},
                {name: 'Evolucion'},
                {name: 'EvolucionAnterior'},
                {name: 'Diagppal'},
                {name: 'Diagrel1'},
                {name: 'DiagRel2'},
                {name: 'DiagRel3'},
                {name: 'Tipodiag'},
                {name: 'Finalidad'},
                {name: 'CausaExterna'},
                {name: 'Ambito'},
                {name: 'FinalidadProc'},
                {name: 'PersonaAtiende'},
                {name: 'FormaActo'}
            ])
        }, cfg));
    }
});
new StoreGridHistorialOrdenamientosHC();

