/*
* @category    Store Examenes Solicitados HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridExaSolicitadosHC = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridExaSolicitadosHC.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridExaSolicitadosHC',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/evolucionhc.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerExaSolicitadosxHC_ofimedical"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'idConsecutivoSolicitud' },
                { name: 'CAS' },
                { name: 'ConsecutivoHC' },
                { name: 'idConcepto' },
                { name: 'codConcepto' },
                { name: 'descConcepto' },
                { name: 'grupoConcepto' },
                { name: 'tipoConcepto' },
                { name: 'Cantidad' },
                { name: 'Posologia' },
                { name: 'dosisDia' },
                { name: 'notasProveedor' },
                { name: 'Remision' }
            ])
        }, cfg));
    }
});
new StoreGridExaSolicitadosHC();

