/*
* @category    Store Evoluciones HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridEvolucionesObservaHospitalizaHC = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridEvolucionesObservaHospitalizaHC.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridEvolucionesObservaHospitalizaHC',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/controlador_observahospitaliza.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerHistorialObservaHospitalizaxPaciente"
            },
            autoLoad: true,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'CAS' },
                { name: 'Paciente' },
                { name: 'ConsecutivoHC' },
                { name: 'FechaAtencion' },
                { name: 'HoraApertura' },
                { name: 'HoraCierre' },
                { name: 'Actividad' },
                { name: 'Plantilla' },
                { name: 'Evolucion' },
                { name: 'TipDoc' },
                { name: 'Documento' },
                { name: 'PrimerApellido' },
                { name: 'SegundoApellido' },
                { name: 'PrimerNombre' },
                { name: 'SegundoNombre' },
                { name: 'FecNac' },
                { name: 'Genero' },
                { name: 'Direccion' },
                { name: 'Telefono' },
                { name: 'Telefono1' },
                { name: 'DocProfe' },
                { name: 'RegProfe' },
                { name: 'NomProfe' },
                { name: 'EspecialidadProfe' },
                { name: 'Cliente' }
            ])
        }, cfg));
    }
});
new StoreGridEvolucionesObservaHospitalizaHC();

