/*
* @category    Store Dientes Actividaees Realizadas x Pacientes HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridDienteActividadesRealizadas = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridDienteActividadesRealizadas.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridDienteActividadesRealizadas',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/uam_odontologia.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerDientesActividadesRealizadas"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'Prestador' },
                { name: 'IPS' },
                { name: 'IdConsecutivoDientesActividad' },
                { name: 'Paciente' },
                { name: 'CAS' },
                { name: 'FechaAtencion' },
                { name: 'Diente' },
                { name: 'Superficie' },
                { name: 'IdProced' },
                { name: 'CodProced' },
                { name: 'DesProced' },
                { name: 'NotasEvolucion' },
                { name: 'Ambito' },
                { name: 'Finalidad' },
                { name: 'VlrActividad' },
                { name: 'VlrCopago' },
                { name: 'VlrNeto' },
                { name: 'Profesional' }
            ]),
            sortInfo:{field: 'FechaAtencion', direction: "DESC"}
        }, cfg));
    }
});
new StoreGridDienteActividadesRealizadas();

